/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelClosingException;
import com.newrelic.DisconnectionHandler;
import com.newrelic.agent.deps.io.grpc.Status;
import com.newrelic.agent.deps.io.grpc.StatusRuntimeException;
import com.newrelic.agent.deps.io.grpc.stub.StreamObserver;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.trace.v1.V1;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class ResponseObserver
implements StreamObserver<V1.RecordStatus> {
    private final MetricAggregator metricAggregator;
    private final Logger logger;
    private final DisconnectionHandler disconnectionHandler;
    private final AtomicBoolean shouldRecreateCall;

    public ResponseObserver(MetricAggregator metricAggregator, Logger logger, DisconnectionHandler disconnectionHandler, AtomicBoolean shouldRecreateCall) {
        this.metricAggregator = metricAggregator;
        this.logger = logger;
        this.disconnectionHandler = disconnectionHandler;
        this.shouldRecreateCall = shouldRecreateCall;
    }

    @Override
    public void onNext(V1.RecordStatus value) {
        this.metricAggregator.incrementCounter("Supportability/InfiniteTracing/Response");
    }

    @Override
    public void onError(Throwable t) {
        if (this.isChannelClosing(t)) {
            this.logger.log(Level.FINE, "Stopping current gRPC call because the channel is closing.");
            return;
        }
        if (this.isAlpnError(t)) {
            this.logger.log(Level.SEVERE, t, "ALPN does not appear to be supported on this JVM. Please install a supported JCE provider or update Java to use Infinite Tracing");
            this.metricAggregator.incrementCounter("Supportability/InfiniteTracing/NoALPNSupport");
            this.disconnectionHandler.terminate();
            return;
        }
        this.logger.log(Level.WARNING, t, "Encountered gRPC exception");
        this.metricAggregator.incrementCounter("Supportability/InfiniteTracing/Response/Error");
        Status status = null;
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            status = statusRuntimeException.getStatus();
            this.metricAggregator.incrementCounter("Supportability/InfiniteTracing/Span/gRPC/" + (Object)((Object)status.getCode()));
        }
        this.disconnectionHandler.handle(status);
    }

    @Override
    public void onCompleted() {
        this.logger.log(Level.FINE, "Completing gRPC call.");
        this.shouldRecreateCall.set(true);
        this.metricAggregator.incrementCounter("Supportability/InfiniteTracing/Response/Completed");
    }

    private boolean isChannelClosing(Throwable t) {
        return t instanceof StatusRuntimeException && t.getCause() instanceof ChannelClosingException;
    }

    private boolean isAlpnError(Throwable t) {
        return t instanceof StatusRuntimeException && t.getCause() instanceof RuntimeException && this.isOkHttpALPNException((RuntimeException)t.getCause());
    }

    private boolean isOkHttpALPNException(RuntimeException cause) {
        return cause.getMessage() != null && cause.getMessage().startsWith("TLS ALPN negotiation failed with protocols");
    }
}

