/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.agent.deps.io.grpc.CallOptions;
import com.newrelic.agent.deps.io.grpc.Channel;
import com.newrelic.agent.deps.io.grpc.ClientCall;
import com.newrelic.agent.deps.io.grpc.ClientInterceptor;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCall;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCallListener;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.MethodDescriptor;
import com.newrelic.agent.interfaces.backport.Supplier;
import java.util.Map;

public class HeadersInterceptor
implements ClientInterceptor {
    private final Supplier<Map<String, String>> headersSupplier;

    public HeadersInterceptor(Supplier<Map<String, String>> headersSupplier) {
        this.headersSupplier = headersSupplier;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                for (Map.Entry header : ((Map)HeadersInterceptor.this.headersSupplier.get()).entrySet()) {
                    headers.put(Metadata.Key.of(((String)header.getKey()).toLowerCase(), Metadata.ASCII_STRING_MARSHALLER), header.getValue());
                }
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

