/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.InfiniteTracingConfig;
import com.newrelic.agent.deps.io.grpc.CallOptions;
import com.newrelic.agent.deps.io.grpc.Channel;
import com.newrelic.agent.deps.io.grpc.ClientCall;
import com.newrelic.agent.deps.io.grpc.ClientInterceptor;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCall;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCallListener;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.MethodDescriptor;
import java.util.logging.Level;

public class FlakyHeaderInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> FLAKY_HEADER = Metadata.Key.of("flaky", Metadata.ASCII_STRING_MARSHALLER);
    private final InfiniteTracingConfig config;

    public FlakyHeaderInterceptor(InfiniteTracingConfig config) {
        this.config = config;
        if (config.getFlakyPercentage() != null) {
            config.getLogger().log(Level.WARNING, "Infinite tracing is configured with a flaky percentage!  There will be errors!");
        }
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final Double flakyPercentage = this.config.getFlakyPercentage();
        if (flakyPercentage == null) {
            return next.newCall(method, callOptions);
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(FLAKY_HEADER, flakyPercentage.toString());
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

