/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.BackoffPolicy;
import com.newrelic.ConnectionStatus;
import com.newrelic.agent.deps.io.grpc.Status;
import com.newrelic.api.agent.Logger;
import java.util.logging.Level;

public class DisconnectionHandler {
    private final ConnectionStatus connectionStatus;
    private final BackoffPolicy backoffPolicy;
    private final Logger logger;

    public DisconnectionHandler(ConnectionStatus connectionStatus, BackoffPolicy backoffPolicy, Logger logger) {
        this.connectionStatus = connectionStatus;
        this.backoffPolicy = backoffPolicy;
        this.logger = logger;
    }

    public void terminate() {
        this.connectionStatus.shutDownForever();
    }

    public void handle(Status responseStatus) {
        if (!this.connectionStatus.shouldReconnect()) {
            return;
        }
        if (!this.backoffPolicy.shouldReconnect(responseStatus)) {
            if (responseStatus != null) {
                this.logger.log(Level.WARNING, "Got gRPC status " + responseStatus.getCode().toString() + ", no longer permitting connections.");
            }
            this.terminate();
        }
        this.logger.log(Level.FINE, "Backing off due to gRPC errors.");
        this.backoffPolicy.backoff();
        this.logger.log(Level.FINE, "Backoff complete, attempting connection.");
        this.connectionStatus.reattemptConnection();
    }
}

