/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.api.agent.Logger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class ConnectionStatus {
    private final Logger logger;
    private final AtomicReference<ConnectionState> currentState = new AtomicReference<ConnectionState>(ConnectionState.CONNECT_NEEDED);

    public ConnectionStatus(Logger logger) {
        this.logger = logger;
    }

    public BlockResult blockOnConnection() throws InterruptedException {
        ConnectionState current;
        while ((current = this.currentState.get()) != ConnectionState.CONNECTED) {
            if (current == ConnectionState.STOPPED_FOREVER) {
                this.logger.log(Level.FINE, "No longer attempting to reconnect to gRPC");
                return BlockResult.GO_AWAY_FOREVER;
            }
            if (this.currentState.compareAndSet(ConnectionState.CONNECT_NEEDED, ConnectionState.CONNECTING)) {
                return BlockResult.MUST_ATTEMPT_CONNECTION;
            }
            Thread.sleep(1000L);
        }
        return BlockResult.ALREADY_CONNECTED;
    }

    public void didConnect() {
        this.currentState.set(ConnectionState.CONNECTED);
    }

    public void shutDownForever() {
        this.currentState.set(ConnectionState.STOPPED_FOREVER);
    }

    public boolean shouldReconnect() {
        return this.currentState.compareAndSet(ConnectionState.CONNECTED, ConnectionState.BACKOFF_PAUSE);
    }

    public void reattemptConnection() {
        this.currentState.set(ConnectionState.CONNECT_NEEDED);
    }

    private static enum ConnectionState {
        CONNECT_NEEDED,
        CONNECTING,
        CONNECTED,
        BACKOFF_PAUSE,
        STOPPED_FOREVER;

    }

    public static enum BlockResult {
        ALREADY_CONNECTED,
        MUST_ATTEMPT_CONNECTION,
        GO_AWAY_FOREVER;

    }
}

