/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelClosingException;
import com.newrelic.Function;
import com.newrelic.StreamObserverFactory;
import com.newrelic.agent.deps.io.grpc.ManagedChannel;
import com.newrelic.agent.deps.io.grpc.stub.ClientCallStreamObserver;
import com.newrelic.trace.v1.V1;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChannelToStreamObserver
implements Function<ManagedChannel, ClientCallStreamObserver<V1.Span>> {
    private final StreamObserverFactory streamObserverFactory;
    private final AtomicBoolean shouldRecreateCall;
    private volatile ManagedChannel lastChannel;
    private volatile ClientCallStreamObserver<V1.Span> streamObserver;

    public ChannelToStreamObserver(StreamObserverFactory streamObserverFactory, AtomicBoolean shouldRecreateCall) {
        this.streamObserverFactory = streamObserverFactory;
        this.shouldRecreateCall = shouldRecreateCall;
    }

    @Override
    public ClientCallStreamObserver<V1.Span> apply(ManagedChannel channel) {
        if (channel == null) {
            return null;
        }
        if (this.lastChannel != channel || this.streamObserver == null || this.shouldRecreateCall.get()) {
            this.recreateStreamObserver(channel);
        }
        return this.streamObserver;
    }

    private void recreateStreamObserver(ManagedChannel channel) {
        this.lastChannel = channel;
        this.clearStreamObserver();
        this.streamObserver = this.streamObserverFactory.buildStreamObserver(channel);
        this.shouldRecreateCall.set(false);
    }

    private void clearStreamObserver() {
        if (this.streamObserver != null) {
            ClientCallStreamObserver<V1.Span> oldStreamObserver = this.streamObserver;
            this.streamObserver = null;
            oldStreamObserver.cancel("CLOSING_CONNECTION", new ChannelClosingException());
        }
    }
}

