/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelFactory;
import com.newrelic.ConnectionStatus;
import com.newrelic.agent.deps.io.grpc.ManagedChannel;
import com.newrelic.agent.interfaces.backport.Supplier;
import com.newrelic.api.agent.Logger;
import java.util.logging.Level;

public class ChannelSupplier
implements Supplier<ManagedChannel> {
    private final ConnectionStatus connectionStatus;
    private final Logger logger;
    private final ChannelFactory channelFactory;
    private volatile ManagedChannel channel;

    public ChannelSupplier(ChannelFactory channelFactory, ConnectionStatus connectionStatus, Logger logger) {
        this.connectionStatus = connectionStatus;
        this.logger = logger;
        this.channelFactory = channelFactory;
        this.channel = null;
    }

    @Override
    public ManagedChannel get() {
        ConnectionStatus.BlockResult blockResult = this.getBlockResult();
        if (blockResult == ConnectionStatus.BlockResult.GO_AWAY_FOREVER) {
            throw new RuntimeException("No longer attempting to connect.");
        }
        if (blockResult == ConnectionStatus.BlockResult.MUST_ATTEMPT_CONNECTION || this.channel == null) {
            this.logger.log(Level.FINE, "Attempting to connect to the Trace Observer.");
            if (this.channel != null) {
                ManagedChannel oldChannel = this.channel;
                this.channel = null;
                oldChannel.shutdown();
            }
            this.channel = this.channelFactory.createChannel();
            this.connectionStatus.didConnect();
        }
        return this.channel;
    }

    public ConnectionStatus.BlockResult getBlockResult() {
        ConnectionStatus.BlockResult blockResult;
        try {
            blockResult = this.connectionStatus.blockOnConnection();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while attempting to connect.");
        }
        return blockResult;
    }
}

