/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.InfiniteTracingConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.io.grpc.ClientInterceptor;
import com.newrelic.agent.deps.io.grpc.ManagedChannel;
import com.newrelic.agent.deps.io.grpc.okhttp.OkHttpChannelBuilder;

public class ChannelFactory {
    private final InfiniteTracingConfig config;
    private final ClientInterceptor[] interceptors;

    public ChannelFactory(InfiniteTracingConfig config, ClientInterceptor ... interceptors) {
        this.config = config;
        this.interceptors = interceptors;
    }

    public ManagedChannel createChannel() {
        OkHttpChannelBuilder okHttpChannelBuilder = (OkHttpChannelBuilder)((OkHttpChannelBuilder)this.newOkHttpChannelBuilder().defaultLoadBalancingPolicy("pick_first")).intercept(this.interceptors);
        if (this.config.getUsePlaintext()) {
            okHttpChannelBuilder.usePlaintext();
        } else {
            okHttpChannelBuilder.useTransportSecurity();
        }
        return okHttpChannelBuilder.build();
    }

    @VisibleForTesting
    OkHttpChannelBuilder newOkHttpChannelBuilder() {
        return OkHttpChannelBuilder.forAddress(this.config.getHost(), this.config.getPort());
    }
}

