/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.weave.utils.JarUtils;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;

public class NewClassAppender {
    private static final ProtectionDomain PROTECTION_DOMAIN = NewClassAppender.class.getProtectionDomain();
    static final Method defineClassMethod;
    static Method addURLMethod;
    static Class<?> builtInClassLoaderClass;
    static Field ucpField;
    static Method urlClassPathAddURLMethod;

    public static void appendClassesToBootstrapClassLoader(Instrumentation instrumentation, Map<String, byte[]> classBytesMap) throws IOException {
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(JarUtils.createJarFile("instrumentation", classBytesMap)));
    }

    public static void appendClasses(ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        NewClassAppender.appendClasses(null, null, null, classloader, classBytesMap);
    }

    public static void appendClasses(String className, String superName, String[] interfaceNames, ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        NewClassAppender.loadClassesInClassLoader(className, superName, interfaceNames, classloader, classBytesMap);
    }

    public static Class<?> defineClass(ClassLoader classloader, String className, byte[] classBytes, int offset, int length, ProtectionDomain protectionDomain) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Class)defineClassMethod.invoke((Object)classloader, className.replace('/', '.'), classBytes, offset, length, protectionDomain);
    }

    private static void loadClassesInClassLoader(String className, String superName, String[] interfaceNames, ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        Set<String> interfaceNamesSet;
        className = className == null ? "" : className;
        superName = superName == null || superName.equals("java/lang/Object") ? "" : superName;
        Set<String> set = interfaceNamesSet = interfaceNames != null ? Sets.newHashSet(interfaceNames) : Collections.emptySet();
        if (classloader instanceof URLClassLoader) {
            if (NewClassAppender.isTransformingCurrentClass(className, superName, interfaceNamesSet, classBytesMap)) {
                try {
                    File utilityClassJar = JarUtils.createJarFile("nr-inst-utilities", classBytesMap);
                    addURLMethod.invoke((Object)classloader, utilityClassJar.toURI().toURL());
                    return;
                }
                catch (Throwable utilityClassJar) {}
            }
        } else if (builtInClassLoaderClass != null && builtInClassLoaderClass.isInstance(classloader) && ucpField != null && NewClassAppender.isTransformingCurrentClass(className, superName, interfaceNamesSet, classBytesMap)) {
            try {
                File utilityClassJar = JarUtils.createJarFile("nr-inst-utilities", classBytesMap);
                Object urlClassPath = ucpField.get(classloader);
                if (urlClassPath != null) {
                    urlClassPathAddURLMethod.invoke(urlClassPath, utilityClassJar.toURI().toURL());
                    return;
                }
            }
            catch (Throwable utilityClassJar) {
                // empty catch block
            }
        }
        boolean continueLoading = true;
        HashMap<String, byte[]> loadedClasses = Maps.newHashMap();
        HashSet<String> unloadedClasses = Sets.newHashSet(classBytesMap.keySet());
        while (continueLoading && unloadedClasses.size() > 0) {
            continueLoading = false;
            for (String classname : unloadedClasses) {
                byte[] classBytes = classBytesMap.get(classname);
                if (null == classBytes) continue;
                try {
                    NewClassAppender.defineClass(classloader, classname.replace('/', '.'), classBytes, 0, classBytes.length, PROTECTION_DOMAIN);
                    continueLoading = true;
                    loadedClasses.put(classname, classBytes);
                }
                catch (Throwable t) {
                    if (t.getCause() instanceof LinkageError) {
                        String errorMessage = t.getCause().getMessage();
                        if (errorMessage == null || !errorMessage.contains("duplicate class definition")) continue;
                        continueLoading = true;
                        loadedClasses.put(classname, classBytes);
                        continue;
                    }
                    throw new IOException(t);
                }
            }
            unloadedClasses.removeAll(loadedClasses.keySet());
        }
        if (unloadedClasses.size() > 0) {
            // empty if block
        }
    }

    private static boolean isTransformingCurrentClass(String className, String superName, Set<String> interfaceNamesSet, Map<String, byte[]> classBytesMap) {
        for (byte[] classBytes : classBytesMap.values()) {
            ClassNode result = WeaveUtils.convertToClassNode(classBytes);
            if (!className.equals(result.name) && !superName.equals(result.name) && !interfaceNamesSet.contains(result.name) && !className.equals(result.superName) && !superName.equals(result.superName)) continue;
            return true;
        }
        return false;
    }

    private NewClassAppender() {
    }

    static {
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            defineClassMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURLMethod.setAccessible(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Class<?> builtInClassLoader = Class.forName("jdk.internal.loader.BuiltinClassLoader");
            Class<?> urlClassPath = Class.forName("jdk.internal.loader.URLClassPath");
            if (builtInClassLoader != null && urlClassPath != null) {
                builtInClassLoaderClass = builtInClassLoader;
                ucpField = builtInClassLoader.getDeclaredField("ucp");
                ucpField.setAccessible(true);
                urlClassPathAddURLMethod = urlClassPath.getDeclaredMethod("addURL", URL.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

