/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.base.Splitter;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.Streams;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class CachedWeavePackage
extends WeavePackage {
    public static final String REFERENCE_CLASSES_MANIFEST_ATTRIBUTE_NAME = "Reference-Classes";
    public static final String ILLEGAL_CLASSES_MANIFEST_ATTRIBUTE_NAME = "Illegal-Classes";
    public static final String WEAVE_CLASSES_MANIFEST_ATTRIBUTE_NAME = "Weave-Classes";
    public static final String WEAVE_METHODS_MANIFEST_ATTRIBUTE_NAME = "Weave-Methods";
    public static final String CLASS_REQUIRED_ANNOTATIONS_MANIFEST_ATTRIBUTE_NAME = "Class-Required-Annotations";
    public static final String METHOD_REQUIRED_ANNOTATIONS_MANIFEST_ATTRIBUTE_NAME = "Method-Required-Annotations";
    private final Set<String> referenceClasses;
    private final Set<String> weaveClasses;
    private final Set<String> weaveMethods;
    private final Set<String> illegalClasses;
    private final Set<String> classRequiredAnnotations;
    private final Set<String> methodRequiredAnnotations;
    private final URL jarLocation;
    private volatile boolean loaded = false;
    private static final Splitter splitter = Splitter.on(',').omitEmptyStrings().trimResults();

    public static WeavePackage createWeavePackage(URL jarLocation, JarInputStream jarStream, WeavePackageConfig config) throws Exception {
        Attributes attributes = jarStream.getManifest().getMainAttributes();
        String weaveMethods = attributes.getValue(WEAVE_METHODS_MANIFEST_ATTRIBUTE_NAME);
        String weaveClasses = attributes.getValue(WEAVE_CLASSES_MANIFEST_ATTRIBUTE_NAME);
        String classRequiredAnnotations = attributes.getValue(CLASS_REQUIRED_ANNOTATIONS_MANIFEST_ATTRIBUTE_NAME);
        String methodRequiredAnnotations = attributes.getValue(METHOD_REQUIRED_ANNOTATIONS_MANIFEST_ATTRIBUTE_NAME);
        if (weaveMethods == null || weaveClasses == null || classRequiredAnnotations == null || methodRequiredAnnotations == null) {
            return WeavePackage.createWeavePackage(jarStream, config);
        }
        String referenceClasses = attributes.getValue(REFERENCE_CLASSES_MANIFEST_ATTRIBUTE_NAME);
        String illegalClasses = attributes.getValue(ILLEGAL_CLASSES_MANIFEST_ATTRIBUTE_NAME);
        HashSet<String> weaveMethodsList = Sets.newHashSet();
        for (String weaveMethod : splitter.split(weaveMethods)) {
            weaveMethodsList.add(weaveMethod.replaceAll("\"", ""));
        }
        HashSet<String> weaveClassesList = Sets.newHashSet(splitter.split(weaveClasses));
        HashSet<String> referenceList = Sets.newHashSet(splitter.split(referenceClasses));
        HashSet<String> classAnnotationsList = Sets.newHashSet(splitter.split(classRequiredAnnotations));
        HashSet<String> methodAnnotationsList = Sets.newHashSet(splitter.split(methodRequiredAnnotations));
        HashSet<String> illegalList = illegalClasses == null ? null : Sets.newHashSet(splitter.split(illegalClasses));
        return new CachedWeavePackage(jarLocation, config, weaveMethodsList, weaveClassesList, referenceList, illegalList, classAnnotationsList, methodAnnotationsList);
    }

    CachedWeavePackage(URL jarLocation, WeavePackageConfig config, Set<String> weaveMethods, Set<String> weaveClasses, Set<String> referenceClasses, Set<String> illegalClasses, Set<String> classRequiredAnnotations, Set<String> methodRequiredAnnotations) {
        super(config, new ArrayList<byte[]>());
        this.weaveMethods = weaveMethods;
        this.weaveClasses = weaveClasses;
        this.referenceClasses = referenceClasses;
        this.illegalClasses = illegalClasses;
        this.classRequiredAnnotations = classRequiredAnnotations;
        this.methodRequiredAnnotations = methodRequiredAnnotations;
        this.jarLocation = jarLocation;
        if (this.isBootstrapClassName(this.weaveClasses)) {
            this.weavesBootstrap = true;
        }
    }

    @Override
    public boolean hasMatcher(String className, String[] superNames, String[] interfaceNames, Set<String> classAnnotations, Set<String> methodAnnotations, ClassCache classCache) throws IOException {
        HashSet<String> matchClassNames = Sets.newHashSet(className);
        if (superNames != null && superNames.length > 0) {
            Collections.addAll(matchClassNames, superNames);
        }
        if (interfaceNames != null && interfaceNames.length > 0) {
            Collections.addAll(matchClassNames, interfaceNames);
        }
        boolean isClassAnnotationMatch = this.classRequiredAnnotations != null && !this.classRequiredAnnotations.isEmpty();
        boolean isMethodAnnotationMatch = this.methodRequiredAnnotations != null && !this.methodRequiredAnnotations.isEmpty();
        matchClassNames.retainAll(this.weaveClasses);
        if (!isClassAnnotationMatch && !isMethodAnnotationMatch && matchClassNames.isEmpty()) {
            return false;
        }
        this.load();
        return super.hasMatcher(className, superNames, interfaceNames, classAnnotations, methodAnnotations, classCache);
    }

    @Override
    public PackageValidationResult validate(ClassCache cache) throws IOException {
        if (this.loaded) {
            return super.validate(cache);
        }
        PackageValidationResult fastResult = new PackageValidationResult(this, cache, this.referenceClasses, this.illegalClasses);
        if (fastResult.succeeded()) {
            this.load();
            return super.validate(cache);
        }
        return fastResult;
    }

    @Override
    public Set<String> getRequiredClasses() {
        HashSet<String> requiredClasses = Sets.newHashSet();
        requiredClasses.addAll(this.weaveClasses);
        requiredClasses.addAll(this.referenceClasses);
        return requiredClasses;
    }

    @Override
    public Set<String> getMethodSignatures() {
        return Sets.newHashSet(this.weaveMethods);
    }

    @Override
    public Set<String> getAllRequiredAnnotationClasses() {
        return Sets.newHashSet(this.classRequiredAnnotations);
    }

    @Override
    public Set<String> getAllRequiredMethodAnnotationClasses() {
        return Sets.newHashSet(this.methodRequiredAnnotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (!this.loaded) {
            CachedWeavePackage cachedWeavePackage = this;
            synchronized (cachedWeavePackage) {
                if (!this.loaded) {
                    try (ZipInputStream jarStream = null;){
                        ArrayList<byte[]> classBytes = new ArrayList<byte[]>();
                        jarStream = new JarInputStream(this.jarLocation.openStream());
                        JarEntry entry = null;
                        while ((entry = ((JarInputStream)jarStream).getNextJarEntry()) != null) {
                            if (!entry.getName().endsWith(".class")) continue;
                            classBytes.add(Streams.read(jarStream, false));
                        }
                        super.processWeaveBytes(classBytes);
                        this.loaded = true;
                    }
                }
            }
        }
    }
}

