/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.ObjectArrays;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.PreparedMatch;
import com.newrelic.weave.utils.SynchronizedClassNode;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.weavepackage.WeavePackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassWeave {
    private final PreparedMatch match;
    private final ClassNode target;
    private final boolean isNonstaticInnerTarget;
    private final List<Method> weavedMethods;
    private final WeavePackage weavePackage;
    private ClassNode composite = new SynchronizedClassNode(458752);

    private ClassWeave(PreparedMatch match, ClassNode target, WeavePackage weavePackage) {
        this.match = match;
        this.target = target;
        this.isNonstaticInnerTarget = WeaveUtils.isNonstaticInnerClass(target);
        this.weavedMethods = new ArrayList<Method>(match.getPreparedMatchedMethods().size());
        this.weavePackage = weavePackage;
    }

    public static ClassWeave weave(PreparedMatch match, ClassNode target, WeavePackage weavePackage) {
        ClassWeave result = new ClassWeave(match, target, weavePackage);
        result.weave();
        return result;
    }

    private void weave() {
        this.weavedMethods.clear();
        this.target.accept(new ClassVisitor(458752, this.composite){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
            }
        });
        WeaveUtils.updateClassVersion(this.composite);
        this.composite.visibleAnnotations = ClassWeave.merge(this.match.getWeaveClassAnnotations().visibleAnnotations, this.target.visibleAnnotations);
        this.composite.invisibleAnnotations = ClassWeave.merge(this.match.getWeaveClassAnnotations().invisibleAnnotations, this.target.invisibleAnnotations);
        Map<String, PreparedMatch.AnnotationInfo> matchedWeaveFieldAnnotations = this.match.getMatchedWeaveFieldAnnotations();
        for (String string : matchedWeaveFieldAnnotations.keySet()) {
            FieldNode compositeField = WeaveUtils.findMatch(this.composite.fields, string);
            if (compositeField == null) continue;
            PreparedMatch.AnnotationInfo weaveField = matchedWeaveFieldAnnotations.get(string);
            compositeField.visibleAnnotations = ClassWeave.merge(weaveField.visibleAnnotations, compositeField.visibleAnnotations);
            compositeField.invisibleAnnotations = ClassWeave.merge(weaveField.invisibleAnnotations, compositeField.invisibleAnnotations);
        }
        MethodNode preparedWeaveAllConstructor = this.match.getPreparedWeaveAllConstructor();
        for (MethodNode matchedMethod : this.match.getPreparedMatchedMethods().values()) {
            MethodNode compositeMethod;
            MethodNode targetMethod;
            if (matchedMethod.name.equals("<init>") && preparedWeaveAllConstructor != null) continue;
            String desc = matchedMethod.desc;
            if (matchedMethod.name.equals("<init>") && this.isNonstaticInnerTarget) {
                Type[] types = ObjectArrays.concat(WeaveUtils.getOuterClassType(this.target), Type.getArgumentTypes(desc));
                desc = Type.getMethodDescriptor(Type.VOID_TYPE, types);
            }
            if ((targetMethod = WeaveUtils.findMatch(this.composite.methods, new Method(matchedMethod.name, desc))) == null) continue;
            if ((targetMethod.access & 0x40) != 0) {
                Method newTarget = ClassWeave.whereDoesTheBridgeGo(targetMethod);
                if (this.match.getPreparedMatchedMethods().containsKey(newTarget)) continue;
                MethodNode newTargetMethod = WeaveUtils.findMatch(this.composite.methods, newTarget);
                if (null != newTargetMethod) {
                    targetMethod = newTargetMethod;
                    matchedMethod = this.makeNewMatchForBridgeWeave("INLINER_" + this.match.getWeaveName(), matchedMethod, newTarget);
                }
            }
            if ((compositeMethod = this.weaveMethod(matchedMethod, targetMethod)) == null) continue;
            MethodNode match = WeaveUtils.findMatch(this.composite.methods, compositeMethod);
            int index = this.composite.methods.indexOf(match);
            if (index == -1) {
                this.composite.methods.add(compositeMethod);
                continue;
            }
            this.composite.methods.remove(index);
            this.composite.methods.add(index, compositeMethod);
        }
        if (preparedWeaveAllConstructor != null) {
            ArrayList<MethodNode> arrayList = new ArrayList<MethodNode>();
            for (MethodNode targetMethod : this.composite.methods) {
                MethodNode compositeMethod;
                if (!targetMethod.name.equals("<init>") || (compositeMethod = this.weaveMethod(preparedWeaveAllConstructor, targetMethod)) == null) continue;
                arrayList.add(compositeMethod);
            }
            for (MethodNode initMethod : arrayList) {
                MethodNode match = WeaveUtils.findMatch(this.composite.methods, initMethod);
                int index = this.composite.methods.indexOf(match);
                if (index == -1) {
                    this.composite.methods.add(initMethod);
                    continue;
                }
                this.composite.methods.remove(index);
                this.composite.methods.add(index, initMethod);
            }
        }
    }

    public static Method whereDoesTheBridgeGo(MethodNode bridgeMethod) {
        if ((bridgeMethod.access & 0x40) == 0) {
            return null;
        }
        MethodNode visitor = WeaveUtils.newMethodNode(bridgeMethod);
        bridgeMethod.accept(visitor);
        MethodInsnNode lastMethodInsn = null;
        for (AbstractInsnNode current = visitor.instructions.getFirst(); null != current; current = current.getNext()) {
            if (current.getType() != 5) continue;
            lastMethodInsn = (MethodInsnNode)current;
        }
        if (lastMethodInsn != null) {
            return new Method(lastMethodInsn.name, lastMethodInsn.desc);
        }
        return null;
    }

    private MethodNode makeNewMatchForBridgeWeave(final String weaveClassName, final MethodNode bridgeMatchMethod, final Method newTarget) {
        final MethodNode result = WeaveUtils.newMethodNode(bridgeMatchMethod);
        bridgeMatchMethod.accept(new MethodVisitor(458752, result){

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (owner.equals(weaveClassName) && name.equals(bridgeMatchMethod.name) && desc.equals(bridgeMatchMethod.desc)) {
                    result.name = newTarget.getName();
                    result.desc = newTarget.getDescriptor();
                    super.visitMethodInsn(opcode, owner, newTarget.getName(), newTarget.getDescriptor(), itf);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        });
        return result;
    }

    private MethodNode weaveMethod(MethodNode weaveMethod, MethodNode targetMethod) {
        if ((weaveMethod.access & 0x400) != 0) {
            return targetMethod;
        }
        if ((targetMethod.access & 0x400) != 0) {
            return targetMethod;
        }
        MethodNode composite = weaveMethod;
        composite.access = targetMethod.access;
        composite.signature = targetMethod.signature;
        composite.exceptions = targetMethod.exceptions;
        String weaveClassName = this.match.getWeaveName();
        String originalClassName = this.match.getOriginalName();
        HashSet<MethodNode> toInline = Sets.newHashSet();
        if (weaveMethod.name.equals("<init>")) {
            composite = MethodProcessors.addWeaveConstructorInvocationsAtEveryReturn(weaveMethod, "INLINER_" + weaveClassName, originalClassName, targetMethod, this.isNonstaticInnerTarget);
            toInline.add(weaveMethod);
        } else {
            toInline.add(targetMethod);
        }
        composite = MethodProcessors.inlineMethods("INLINER_" + weaveClassName, toInline, this.target.name, composite);
        composite = MethodProcessors.removeJSRInstructions(composite);
        composite = MethodProcessors.updateOwner(composite, originalClassName, weaveClassName, this.match.getPreparedMatchedMethods().keySet(), this.match.getMatchedWeaveFieldAnnotations().keySet());
        composite.invisibleAnnotations = ClassWeave.merge(weaveMethod.invisibleAnnotations, targetMethod.invisibleAnnotations);
        composite.visibleAnnotations = ClassWeave.merge(weaveMethod.visibleAnnotations, targetMethod.visibleAnnotations);
        for (int i = 0; i < Type.getArgumentTypes(composite.desc).length; ++i) {
            if (composite.visibleParameterAnnotations != null) {
                composite.visibleParameterAnnotations[i] = ClassWeave.merge(ClassWeave.safeGet(weaveMethod.visibleParameterAnnotations, i), ClassWeave.safeGet(targetMethod.visibleParameterAnnotations, i));
            }
            if (composite.invisibleParameterAnnotations == null) continue;
            composite.invisibleParameterAnnotations[i] = ClassWeave.merge(ClassWeave.safeGet(weaveMethod.invisibleParameterAnnotations, i), ClassWeave.safeGet(targetMethod.invisibleParameterAnnotations, i));
        }
        this.weavedMethods.add(new Method(targetMethod.name, targetMethod.desc));
        return composite;
    }

    private static List<AnnotationNode> safeGet(List<AnnotationNode>[] annotations, int i) {
        return annotations == null ? null : annotations[i];
    }

    private static List<AnnotationNode> merge(List<AnnotationNode> weave, List<AnnotationNode> composite) {
        if (weave == null || weave.isEmpty()) {
            return composite;
        }
        if (composite == null || composite.isEmpty()) {
            return Lists.newArrayList(weave);
        }
        HashMap<String, AnnotationNode> annotationMap = Maps.newHashMap();
        for (AnnotationNode compositeAnnotation : composite) {
            annotationMap.put(compositeAnnotation.desc, compositeAnnotation);
        }
        for (AnnotationNode weaveAnnotation : weave) {
            annotationMap.put(weaveAnnotation.desc, weaveAnnotation);
        }
        return Lists.newArrayList(annotationMap.values());
    }

    public ClassNode getComposite() {
        return this.composite;
    }

    public PreparedMatch getMatch() {
        return this.match;
    }

    public List<Method> getWeavedMethods() {
        return this.weavedMethods;
    }
}

