/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.CloudVendor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class PCF
implements CloudVendor {
    static String PROVIDER = "pcf";
    private static final String CF_INSTANCE_GUID_ENV = "CF_INSTANCE_GUID";
    private static final String CF_INSTANCE_IP_ENV = "CF_INSTANCE_IP";
    private static final String MEMORY_LIMIT_ENV = "MEMORY_LIMIT";
    private static final String PCF_INSTANCE_GUID_KEY = "cf_instance_guid";
    private static final String PCF_INSTANCE_IP_KEY = "cf_instance_ip";
    private static final String PCF_MEMORY_LIMIT_KEY = "memory_limit";

    @Override
    public PcfData getData() {
        String memoryLimit;
        String cfInstanceGuid = this.getPcfValue(CF_INSTANCE_GUID_ENV);
        String cfInstanceIp = cfInstanceGuid == null ? null : this.getPcfValue(CF_INSTANCE_IP_ENV);
        String string = memoryLimit = cfInstanceIp == null ? null : this.getPcfValue(MEMORY_LIMIT_ENV);
        if (cfInstanceGuid == null || cfInstanceIp == null || memoryLimit == null) {
            return PcfData.EMPTY_DATA;
        }
        if (CloudUtility.isInvalidValue(cfInstanceGuid) || CloudUtility.isInvalidValue(cfInstanceIp) || CloudUtility.isInvalidValue(memoryLimit)) {
            Agent.LOG.log(Level.WARNING, "Failed to validate PCF value");
            PCF.recordPcfError();
            return PcfData.EMPTY_DATA;
        }
        PcfData data = new PcfData(cfInstanceGuid, cfInstanceIp, memoryLimit);
        Agent.LOG.log(Level.FINEST, "Found {0}", data);
        return data;
    }

    protected String getPcfValue(String envVar) {
        try {
            return envVar == null ? null : System.getenv(envVar);
        }
        catch (SecurityException ex) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Error occurred trying to get PCF value {0}", envVar));
            PCF.recordPcfError();
            return null;
        }
    }

    private static void recordPcfError() {
        CloudUtility.recordError("Supportability/utilization/pcf/error");
    }

    protected static class PcfData
    implements CloudData {
        String cfInstanceGuid;
        String cfInstanceIp;
        String memoryLimit;
        static final PcfData EMPTY_DATA = new PcfData();

        private PcfData() {
            this.cfInstanceGuid = null;
            this.cfInstanceIp = null;
            this.memoryLimit = null;
        }

        protected PcfData(String guid, String ip, String memory) {
            this.cfInstanceGuid = guid;
            this.cfInstanceIp = ip;
            this.memoryLimit = memory;
        }

        public String getInstanceGuid() {
            return this.cfInstanceGuid;
        }

        public String getInstanceIp() {
            return this.cfInstanceIp;
        }

        public String getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public Map<String, String> getValueMap() {
            HashMap<String, String> pcf = new HashMap<String, String>();
            if (this.cfInstanceGuid == null || this.cfInstanceIp == null || this.memoryLimit == null) {
                return pcf;
            }
            pcf.put(PCF.PCF_INSTANCE_GUID_KEY, this.cfInstanceGuid);
            pcf.put(PCF.PCF_INSTANCE_IP_KEY, this.cfInstanceIp);
            pcf.put(PCF.PCF_MEMORY_LIMIT_KEY, this.memoryLimit);
            return pcf;
        }

        @Override
        public String getProvider() {
            return PROVIDER;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY_DATA;
        }

        public String toString() {
            return "PcfData{cfInstanceGuid='" + this.cfInstanceGuid + '\'' + ", cfInstanceIp='" + this.cfInstanceIp + '\'' + ", memoryLimit='" + this.memoryLimit + '\'' + '}';
        }
    }
}

