/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.deps.org.apache.commons.codec.binary.Base64;
import com.newrelic.agent.deps.org.json.simple.JSONValue;
import com.newrelic.agent.service.ServiceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class DataSenderWriter
extends OutputStreamWriter {
    private static final int COMPRESSION_LEVEL = -1;

    protected DataSenderWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out, "UTF-8");
    }

    public static final String nullValue() {
        return "null";
    }

    public static final boolean isCompressingWriter(Writer writer) {
        return !(writer instanceof DataSenderWriter);
    }

    public static Object getJsonifiedOptionallyCompressedEncodedString(Object data, Writer writer) {
        return DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(data, writer, -1);
    }

    public static Object getJsonifiedOptionallyCompressedEncodedString(Object data, Writer writer, int compressionLevel) {
        if (writer instanceof DataSenderWriter) {
            return DataSenderWriter.toJSONString(data);
        }
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().isSimpleCompression()) {
            return data;
        }
        return DataSenderWriter.getJsonifiedCompressedEncodedString(data, compressionLevel);
    }

    public static Object getJsonifiedOptionallyCompressedEncodedString(Object data, Writer writer, int compressionLevel, int resultSizeLimitInBytes) {
        String compressedResult = DataSenderWriter.getJsonifiedCompressedEncodedString(data, compressionLevel);
        if (compressedResult.length() > resultSizeLimitInBytes) {
            return null;
        }
        if (writer instanceof DataSenderWriter) {
            return DataSenderWriter.toJSONString(data);
        }
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().isSimpleCompression()) {
            return data;
        }
        return compressedResult;
    }

    public static String toJSONString(Object obj) {
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        try {
            DataSenderWriter writer = new DataSenderWriter(oStream);
            JSONValue.writeJSONString(obj, writer);
            ((Writer)writer).close();
            return oStream.toString("UTF-8");
        }
        catch (IOException e) {
            return JSONValue.toJSONString(obj);
        }
    }

    private static String getJsonifiedCompressedEncodedString(Object data, int compressionLevel) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream zipStream = new DeflaterOutputStream((OutputStream)outStream, new Deflater(compressionLevel));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)zipStream, "UTF-8");
            JSONValue.writeJSONString(data, out);
            ((Writer)out).flush();
            ((Writer)out).close();
            outStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.encodeBase64String(outStream.toByteArray());
    }
}

