/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.MinMaxPriorityQueue;
import com.newrelic.agent.deps.com.google.common.collect.Queues;
import com.newrelic.agent.service.analytics.PriorityAware;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class DistributedSamplingPriorityQueue<E extends PriorityAware> {
    private final String appName;
    private final String serviceName;
    private final Queue<E> data;
    private final AtomicInteger numberOfTries = new AtomicInteger();
    private final AtomicInteger recorded;
    private final AtomicInteger decided;
    private final int decidedLast;
    private final int target;
    private final Comparator<E> comparator;

    public DistributedSamplingPriorityQueue(int reservoirSize) {
        this("", "", reservoirSize, 0, 0, null);
    }

    public DistributedSamplingPriorityQueue(String appName, String serviceName, int reservoirSize) {
        this(appName, serviceName, reservoirSize, 0, 0, null);
    }

    public DistributedSamplingPriorityQueue(int reservoirSize, int decidedLast, int target) {
        this("", "", reservoirSize, decidedLast, target, null);
    }

    public DistributedSamplingPriorityQueue(String appName, String serviceName, int reservoirSize, int decidedLast, int target) {
        this(appName, serviceName, reservoirSize, decidedLast, target, null);
    }

    public DistributedSamplingPriorityQueue(int reservoirSize, int decidedLast, int target, Comparator<E> comparator) {
        this("", "", reservoirSize, decidedLast, target, comparator);
    }

    public DistributedSamplingPriorityQueue(String appName, String serviceName, int reservoirSize, int decidedLast, int target, Comparator<E> comparator) {
        this.appName = appName;
        this.serviceName = serviceName;
        this.comparator = comparator == null ? this.getPriorityAwareComparator() : comparator;
        this.data = this.createQueue(reservoirSize, this.comparator);
        this.recorded = new AtomicInteger(0);
        this.decidedLast = decidedLast;
        this.target = target;
        this.decided = new AtomicInteger(0);
    }

    private Queue<E> createQueue(int reservoirSize, Comparator<E> comparator) {
        if (reservoirSize <= 0) {
            return new NoOpQueue();
        }
        return Queues.synchronizedQueue(MinMaxPriorityQueue.orderedBy(comparator).maximumSize(reservoirSize).create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryAll(DistributedSamplingPriorityQueue<E> source) {
        Queue<E> queue = source.data;
        synchronized (queue) {
            for (PriorityAware element : source.data) {
                this.add(element);
            }
        }
    }

    public int getNumberOfTries() {
        return this.numberOfTries.get();
    }

    public boolean add(E element) {
        this.numberOfTries.incrementAndGet();
        boolean added = this.data.offer(element);
        if (added && element.decider()) {
            this.decided.incrementAndGet();
            if (DistributedTraceUtil.isSampledPriority(element.getPriority())) {
                this.recorded.incrementAndGet();
            }
        }
        return added;
    }

    public E peek() {
        return (E)((PriorityAware)this.data.peek());
    }

    public E poll() {
        return (E)((PriorityAware)this.data.poll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> asList() {
        ArrayList<E> elements;
        Queue<E> queue = this.data;
        synchronized (queue) {
            elements = Lists.newArrayList(this.data);
        }
        Collections.sort(elements, this.comparator);
        return elements;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getSampled() {
        return this.recorded.get();
    }

    public int getDecided() {
        return this.decided.get();
    }

    public int getTarget() {
        return this.target;
    }

    public int getDecidedLast() {
        return this.decidedLast;
    }

    public int size() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
    }

    private Comparator<E> getPriorityAwareComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E left, E right) {
                return Float.compare(right.getPriority(), left.getPriority());
            }
        };
    }

    private static final class NoOpQueue<E extends PriorityAware>
    implements Queue<E> {
        private NoOpQueue() {
        }

        @Override
        public boolean add(E e) {
            return false;
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E remove() {
            return null;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E element() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public void remove() {
                }

                @Override
                public E next() {
                    return null;
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }
    }
}

