/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.SerialVersionUIDAdder;
import com.newrelic.agent.instrumentation.AgentClassWriter;
import com.newrelic.agent.instrumentation.ClassLoaderCheck;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class InstrumentationUtils {
    public static final int JAVA_7_VERSION_NO = 51;
    private static final int JAVA_CLASS_VERSION_BYTE_OFFSET = 6;

    public static boolean isAbleToResolveAgent(ClassLoader loader, String className) {
        try {
            ClassLoaderCheck.loadAgentClass(loader);
            return true;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Classloader {0} failed to load Agent class. The agent might need to be loaded by the bootstrap classloader.: {1}", loader.getClass().getName(), t);
            Agent.LOG.finer(msg);
            return false;
        }
    }

    public static ClassWriter getClassWriter(ClassReader cr, ClassLoader classLoader) {
        int writerFlags = 1;
        if (InstrumentationUtils.shouldComputeFrames(cr)) {
            writerFlags = 2;
        }
        return new AgentClassWriter(cr, writerFlags, classLoader);
    }

    private static boolean shouldComputeFrames(ClassReader cr) {
        if (InstrumentationUtils.getClassJavaVersion(cr) < 51) {
            return false;
        }
        return ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig().computeFrames();
    }

    public static byte[] generateClassBytesWithSerialVersionUID(ClassReader classReader, int classReaderFlags, ClassLoader classLoader) {
        ClassWriter cw = InstrumentationUtils.getClassWriter(classReader, classLoader);
        SerialVersionUIDAdder cv = new SerialVersionUIDAdder(cw);
        classReader.accept(cv, classReaderFlags);
        return cw.toByteArray();
    }

    public static byte[] generateClassBytesWithSerialVersionUID(byte[] classBytes, int classReaderFlags, ClassLoader classLoader) {
        ClassReader cr = new ClassReader(classBytes);
        return InstrumentationUtils.generateClassBytesWithSerialVersionUID(cr, classReaderFlags, classLoader);
    }

    public static boolean isAnnotation(ClassReader cr) {
        return (cr.getAccess() & 0x2000) != 0;
    }

    public static boolean isInterface(ClassReader cr) {
        return (cr.getAccess() & 0x200) != 0;
    }

    public static boolean isDefaultMethodSupported(ClassReader cr) {
        return InstrumentationUtils.getClassJavaVersion(cr) > 51;
    }

    private static int getClassJavaVersion(ClassReader cr) {
        return cr.readUnsignedShort(6);
    }

    public static Set<Method> getDeclaredMethods(Class<?> clazz) {
        java.lang.reflect.Method[] methods = clazz.getDeclaredMethods();
        HashSet<Method> result = new HashSet<Method>(methods.length);
        for (java.lang.reflect.Method method : methods) {
            result.add(InstrumentationUtils.getMethod(method));
        }
        return result;
    }

    public static Method getMethod(java.lang.reflect.Method method) {
        Class<?>[] params = method.getParameterTypes();
        Type[] args = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = Type.getType(params[i]);
        }
        return new Method(method.getName(), Type.getType(method.getReturnType()), args);
    }
}

