/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.errors.TracedError;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

public class HttpTracedError
extends TracedError {
    private static int UNKNOWN_STATUS_CODE = -1;
    private final int maxUserParameterSize;
    private final int responseStatus;
    private final String errorMessage;

    private HttpTracedError(ErrorCollectorConfig errorCollectorConfig, int maxUserParameterSize, String appName, String frontendMetricName, String requestUri, int responseStatus, String errorMessage, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics, TransactionData transactionData, boolean expected) {
        super(errorCollectorConfig, appName, frontendMetricName, timestamp, requestUri, prefixedParams, userParams, agentParams, errorParams, intrinsics, transactionData, expected);
        this.maxUserParameterSize = maxUserParameterSize;
        this.responseStatus = responseStatus;
        this.errorMessage = errorMessage == null && responseStatus != UNKNOWN_STATUS_CODE ? this.getStatusErrorMessage(responseStatus) : errorMessage;
    }

    public static HttpTracedErrorRequired builder(ErrorCollectorConfig errorCollectorConfig, int maxUserParameterSize, String appName, String frontendMetricName, long timestampInMillis) {
        return new Builder(errorCollectorConfig, maxUserParameterSize, appName, frontendMetricName, timestampInMillis);
    }

    @Override
    public Collection<String> stackTrace() {
        return null;
    }

    @Override
    public String getExceptionClass() {
        String message = this.getMessage();
        try {
            if (message != null && message.getBytes("UTF-8").length > this.maxUserParameterSize) {
                message = this.getStatusErrorMessage(this.responseStatus);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return message;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    private String getStatusErrorMessage(int responseStatus) {
        if (responseStatus >= 400 && responseStatus < 500) {
            return "HttpClientError " + responseStatus;
        }
        return "HttpServerError " + responseStatus;
    }

    public int getStatusCode() {
        return this.responseStatus;
    }

    @Override
    public boolean incrementsErrorMetric() {
        boolean isExpectedStatusCode = this.errorCollectorConfig.getExpectedStatusCodes().contains(this.responseStatus);
        return !this.expected && !isExpectedStatusCode;
    }

    public String toString() {
        return MessageFormat.format("{0} ({1})", this.getMessage(), this.responseStatus);
    }

    public static interface HttpTracedErrorRequired {
        public Builder statusCodeAndMessage(int var1, String var2);

        public Builder message(String var1);
    }

    public static class Builder
    extends TracedError.Builder
    implements HttpTracedErrorRequired {
        private int maxUserParameterSize;
        private int responseStatus;
        private String errorMessage;

        Builder(ErrorCollectorConfig errorCollectorConfig, int maxUserParameterSize, String appName, String frontendMetricName, long timestampInMillis) {
            super(errorCollectorConfig, appName, frontendMetricName, timestampInMillis);
            this.maxUserParameterSize = maxUserParameterSize;
        }

        @Override
        public Builder statusCodeAndMessage(int responseStatus, String errorMessage) {
            this.responseStatus = responseStatus;
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public Builder message(String errorMessage) {
            this.responseStatus = UNKNOWN_STATUS_CODE;
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public HttpTracedError build() {
            return new HttpTracedError(this.errorCollectorConfig, this.maxUserParameterSize, this.appName, this.frontendMetricName, this.requestUri, this.responseStatus, this.errorMessage, this.timestampInMillis, this.prefixedAttributes, this.userAttributes, this.agentAttributes, this.errorAttributes, this.intrinsicAttributes, this.transactionData, this.expected);
        }
    }
}

