/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ClassHistogramConfig;
import com.newrelic.agent.heap.ClassHistogramHelper;
import java.util.Map;

public class ClassHistogramConfigImpl
extends BaseConfig
implements ClassHistogramConfig {
    public static final String PROPERTY_NAME = "class_histogram";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.class_histogram.";
    public static final String ENABLED = "enabled";
    public static final boolean DEFAULT_ENABLED = false;
    public static final String CLASSES_PER_HISTOGRAM = "classes_per_histogram";
    public static final int DEFAULT_CLASSES_PER_HISTOGRAM = 49;
    public static final int CLASSES_PER_HISTOGRAM_LIMIT = 500;
    public static final String JAVA_HOME = System.getenv("JAVA_HOME");
    public static final String JMAP_PATH = "jmap_path";
    public static final String DEFAULT_JMAP_PATH = JAVA_HOME + (ClassHistogramHelper.isWindows() ? "\\bin\\" : "/bin/");
    private final boolean enabled = this.getProperty("enabled", false);
    private final int numClassesPerHistogram;
    private final String jmapPath;

    public ClassHistogramConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        int cph = this.getProperty(CLASSES_PER_HISTOGRAM, 49);
        this.numClassesPerHistogram = cph < 1 ? 49 : (cph > 500 ? 500 : cph);
        String rawPath = this.getProperty(JMAP_PATH, DEFAULT_JMAP_PATH);
        this.jmapPath = ClassHistogramHelper.isWindows() ? ((rawPath = rawPath.replace("\"", "")).endsWith("\\") ? rawPath : rawPath + "\\") : (rawPath.endsWith("/") ? rawPath : rawPath + "/");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public int classesPerHistogram() {
        return this.numClassesPerHistogram;
    }

    @Override
    public String jmapPath() {
        return this.jmapPath;
    }
}

