/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.com.google.common.collect.MapDifference;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class AttributeSender {
    protected static String ATTRIBUTE_TYPE;
    private boolean transactional = true;
    private static final Set<String> sendParametersOutsideOfTxn;
    private static final int maxUserParameters;

    protected abstract String getAttributeType();

    protected abstract Map<String, Object> getAttributeMap() throws Throwable;

    protected void setTransactional(boolean newSetting) {
        this.transactional = newSetting;
    }

    protected void addCustomAttributeImpl(String key, Object value, String methodName) {
        block5: {
            Object filteredValue = this.verifyParameterAndReturnValue(key, value, methodName);
            if (filteredValue == null) {
                return;
            }
            try {
                Map<String, Object> attributeMap = this.getAttributeMap();
                if (attributeMap != null) {
                    attributeMap.put(key, filteredValue);
                    Agent.LOG.log(Level.FINER, "Added {0} attribute \"{1}\": {2}", this.getAttributeType(), key, filteredValue);
                    MetricNames.recordApiSupportabilityMetric("AddCustomParameter");
                }
            }
            catch (Throwable t) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Exception adding attribute for key: \"{0}\": {1}", key, t);
                }
                if (!Agent.LOG.isLoggable(Level.FINER)) break block5;
                Agent.LOG.log(Level.FINER, "Exception adding attribute for key: \"{0}\": {1}", key);
            }
        }
    }

    protected void addCustomAttributesImpl(Map<String, Object> params, String methodName) {
        block5: {
            Map<String, Object> filteredValues = this.verifyParametersAndReturnValues(params, methodName);
            if (filteredValues == null || filteredValues.isEmpty()) {
                return;
            }
            try {
                Map<String, Object> attributeMap = this.getAttributeMap();
                if (attributeMap != null) {
                    attributeMap.putAll(filteredValues);
                    Agent.LOG.log(Level.FINER, "Added {0} attributes \"{1}\"", this.getAttributeType(), filteredValues);
                    MetricNames.recordApiSupportabilityMetric("AddCustomParameter");
                }
            }
            catch (Throwable t) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Exception adding attributes for keys: \"{0}\": {1}", filteredValues.keySet(), t);
                }
                if (!Agent.LOG.isLoggable(Level.FINER)) break block5;
                Agent.LOG.log(Level.FINER, "Exception adding attributes for keys: \"{0}\": {1}", filteredValues.keySet());
            }
        }
    }

    public Object verifyParameterAndReturnValue(String key, Object value, String methodCalled) {
        int maxUserParameterSize;
        if (key == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null key", this.getAttributeType(), methodCalled);
            return null;
        }
        if (value == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null value for key \"{2}\"", this.getAttributeType(), methodCalled, key);
            return null;
        }
        Transaction tx = Transaction.getTransaction(false);
        int n = maxUserParameterSize = tx == null ? ServiceFactory.getConfigService().getDefaultAgentConfig().getMaxUserParameterSize() : tx.getAgentConfig().getMaxUserParameterSize();
        if (!this.validateAndLogKeyLength(key, maxUserParameterSize, methodCalled)) {
            return null;
        }
        if (value instanceof String) {
            value = this.truncateValue(key, (String)value, maxUserParameterSize, methodCalled);
        }
        if (sendParametersOutsideOfTxn.contains(methodCalled)) {
            return value;
        }
        if (this.transactional && (tx == null || !tx.isInProgress())) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute with key \"{1}\" because {2} was invoked outside a New Relic transaction.", this.getAttributeType(), key, methodCalled);
            return null;
        }
        return value;
    }

    public Map<String, Object> verifyParametersAndReturnValues(Map<String, Object> params, String methodCalled) {
        LinkedHashMap<String, Object> verifiedParams = new LinkedHashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            return Collections.emptyMap();
        }
        Transaction tx = Transaction.getTransaction(false);
        int maxUserParameterSize = tx == null ? ServiceFactory.getConfigService().getDefaultAgentConfig().getMaxUserParameterSize() : tx.getAgentConfig().getMaxUserParameterSize();
        for (Map.Entry<String, Object> current : params.entrySet()) {
            String currentKey = current.getKey();
            Object currentValue = current.getValue();
            if (currentKey == null) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null key", this.getAttributeType(), methodCalled);
                continue;
            }
            if (currentValue == null) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null value for key \"{2}\"", this.getAttributeType(), methodCalled, currentKey);
                continue;
            }
            if (!this.validateAndLogKeyLength(currentKey, maxUserParameterSize, methodCalled)) continue;
            if (currentValue instanceof String) {
                currentValue = this.truncateValue(currentKey, (String)currentValue, maxUserParameterSize, methodCalled);
            }
            int remainingParamCapacity = maxUserParameters - verifiedParams.size();
            if (sendParametersOutsideOfTxn.contains(methodCalled)) {
                if (remainingParamCapacity > 0) {
                    verifiedParams.put(currentKey, currentValue);
                    continue;
                }
                this.logParametersToDrop(verifiedParams, params);
                return verifiedParams;
            }
            if (this.transactional && (tx == null || !tx.isInProgress())) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attributes with keys \"{1}\" because {2} was invoked outside a New Relic transaction.", this.getAttributeType(), params.keySet(), methodCalled);
                return Collections.emptyMap();
            }
            if (remainingParamCapacity > 0) {
                verifiedParams.put(currentKey, currentValue);
                continue;
            }
            this.logParametersToDrop(verifiedParams, params);
            return verifiedParams;
        }
        return verifiedParams;
    }

    private void logParametersToDrop(Map<String, Object> verified, Map<String, Object> allParams) {
        MapDifference<String, Object> diff = Maps.difference(verified, allParams);
        Agent.LOG.log(Level.FINER, "Unable to add attributes for keys \"{0}\" because the limit on {1} attributes has been reached.", diff.entriesOnlyOnRight().keySet(), this.getAttributeType());
    }

    private String truncateValue(String key, String value, int maxUserParameterSize, String methodCalled) {
        String truncatedVal = AttributeSender.truncateString(value, maxUserParameterSize);
        if (!value.equals(truncatedVal)) {
            Agent.LOG.log(Level.FINER, "{0} was invoked with a value longer than {2} bytes for key \"{3}\". The value will be shortened to the first {4} characters.", methodCalled, value, maxUserParameterSize, key, truncatedVal.length());
        }
        return truncatedVal;
    }

    private boolean validateAndLogKeyLength(String key, int maxUserParameterSize, String methodCalled) {
        try {
            if (key.getBytes("UTF-8").length > maxUserParameterSize) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a key longer than {2} bytes. Key is \"{3}\".", this.getAttributeType(), methodCalled, maxUserParameterSize, key);
                return false;
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Exception while verifying attribute", t);
            return false;
        }
        return true;
    }

    public static String truncateString(String s, int maxBytes) {
        int truncatedSize = 0;
        for (int i = 0; i < s.length(); ++i) {
            int characterSize;
            char c = s.charAt(i);
            if (c <= '\u007f') {
                characterSize = 1;
            } else if (c <= '\u07ff') {
                characterSize = 2;
            } else if (c <= '\ud7ff') {
                characterSize = 3;
            } else if (c <= '\udfff') {
                characterSize = 4;
                ++i;
            } else {
                characterSize = 3;
            }
            if (truncatedSize + characterSize > maxBytes) {
                return s.substring(0, i);
            }
            truncatedSize += characterSize;
        }
        return s;
    }

    public void addAttribute(String key, String value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Number value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Boolean value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Map<String, String> values, String methodName) {
        this.addCustomAttributeImpl(key, values, methodName);
    }

    public void addAttributes(Map<String, Object> params, String methodName) {
        this.addCustomAttributesImpl(params, methodName);
    }

    static {
        sendParametersOutsideOfTxn = ImmutableSet.of("noticeError", "Span.addCustomParameter", "Span.addCustomParameters");
        maxUserParameters = ServiceFactory.getConfigService().getDefaultAgentConfig().getMaxUserParameters();
    }
}

