/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.HeadersUtil;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import java.io.UnsupportedEncodingException;

public class DeobfuscatedInboundHeaders
implements InboundHeaders {
    InboundHeaders delegate;
    String encodingKey;

    public DeobfuscatedInboundHeaders(InboundHeaders headers, String encodingKey) {
        this.delegate = headers;
        this.encodingKey = encodingKey;
    }

    public HeaderType getHeaderType() {
        return this.delegate.getHeaderType();
    }

    public String getHeader(String name) {
        if (this.encodingKey == null && !this.isDistributedTraceHeader(name)) {
            return null;
        }
        if (HeadersUtil.NEWRELIC_HEADERS.contains(name)) {
            String obfuscatedValue = this.delegate.getHeader(name);
            if (obfuscatedValue == null) {
                obfuscatedValue = this.delegate.getHeader(name.toUpperCase());
            }
            if (obfuscatedValue == null) {
                obfuscatedValue = this.delegate.getHeader(name.toLowerCase());
            }
            if (obfuscatedValue == null) {
                return null;
            }
            try {
                return Obfuscator.deobfuscateNameUsingKey(obfuscatedValue, this.encodingKey);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        String value = this.delegate.getHeader(name);
        if (value == null) {
            value = this.delegate.getHeader(name.toUpperCase());
        }
        if (value == null) {
            value = this.delegate.getHeader(name.toLowerCase());
        }
        return value;
    }

    private boolean isDistributedTraceHeader(String name) {
        return name.equalsIgnoreCase("newrelic") || name.equalsIgnoreCase("newrelic");
    }
}

