/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.yaml.snakeyaml.nodes;

import com.newrelic.org.yaml.snakeyaml.error.Mark;
import com.newrelic.org.yaml.snakeyaml.nodes.CollectionNode;
import com.newrelic.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.org.yaml.snakeyaml.nodes.NodeId;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingNode
extends CollectionNode {
    private Class<? extends Object> keyType;
    private Class<? extends Object> valueType;

    public MappingNode(String tag, List<Node[]> value, Mark startMark, Mark endMark, Boolean flowStyle) {
        super(tag, value, startMark, endMark, flowStyle);
        this.keyType = Object.class;
        this.valueType = Object.class;
    }

    public MappingNode(String tag, List<Node[]> value, Boolean flowStyle) {
        super(tag, value, null, null, flowStyle);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.mapping;
    }

    @Override
    public List<Node[]> getValue() {
        List mapping = (List)super.getValue();
        for (Node[] nodes : mapping) {
            nodes[0].setType(this.keyType);
            nodes[1].setType(this.valueType);
        }
        return mapping;
    }

    public void setValue(List<Node[]> merge) {
        this.value = merge;
    }

    public void setKeyType(Class<? extends Object> keyType) {
        this.keyType = keyType;
    }

    public void setValueType(Class<? extends Object> valueType) {
        this.valueType = valueType;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator i$ = this.getValue().iterator();
        while (i$.hasNext()) {
            Node[] node = (Node[])i$.next();
            buf.append("{ key=");
            buf.append(node[0]);
            buf.append("; value=");
            buf.append(System.identityHashCode(node[1]));
            buf.append(" }");
        }
        String values = buf.toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + values + ")>";
    }
}

