/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.core.subst;

import com.newrelic.ch.qos.logback.core.CoreConstants;
import com.newrelic.ch.qos.logback.core.spi.ScanException;
import com.newrelic.ch.qos.logback.core.subst.Node;
import com.newrelic.ch.qos.logback.core.subst.Token;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    final List<Token> tokenList;
    int pointer = 0;

    public Parser(List<Token> tokenList) {
        this.tokenList = tokenList;
    }

    public Node parse() throws ScanException {
        return this.E();
    }

    private Node E() throws ScanException {
        Node t = this.T();
        if (t == null) {
            return null;
        }
        Node eOpt = this.Eopt();
        if (eOpt != null) {
            this.appendNode(t, eOpt);
        }
        return t;
    }

    private Node Eopt() throws ScanException {
        Token next = this.getCurentToken();
        if (next == null) {
            return null;
        }
        return this.E();
    }

    private Node T() throws ScanException {
        Token t = this.getCurentToken();
        switch (t.type) {
            case LITERAL: {
                this.advanceTokenPointer();
                return new Node(Node.Type.LITERAL, t.payload);
            }
            case CURLY_LEFT: {
                this.advanceTokenPointer();
                Node inner = this.E();
                Token right = this.getCurentToken();
                this.expectCurlyRight(right);
                this.advanceTokenPointer();
                Node curlyLeft = new Node(Node.Type.LITERAL, CoreConstants.LEFT_ACCOLADE);
                curlyLeft.next = inner;
                Node curlyRightNode = new Node(Node.Type.LITERAL, CoreConstants.RIGHT_ACCOLADE);
                if (inner == null) {
                    curlyLeft.next = curlyRightNode;
                } else {
                    this.appendNode(inner, curlyRightNode);
                }
                return curlyLeft;
            }
            case START: {
                this.advanceTokenPointer();
                Node v = this.V();
                Token w = this.getCurentToken();
                this.expectCurlyRight(w);
                this.advanceTokenPointer();
                return v;
            }
        }
        return null;
    }

    private void appendNode(Node node, Node additionalNode) {
        Node n = node;
        while (true) {
            if (n.next == null) {
                n.next = additionalNode;
                return;
            }
            n = n.next;
        }
    }

    private Node V() throws ScanException {
        Node e = this.E();
        Node variable = new Node(Node.Type.VARIABLE, e);
        Token t = this.getCurentToken();
        if (t != null && t.type == Token.Type.DEFAULT) {
            this.advanceTokenPointer();
            Node def = this.E();
            variable.defaultPart = def;
        }
        return variable;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token t, String expected) {
        if (t == null) {
            throw new IllegalArgumentException("All tokens consumed but was expecting \"" + expected + "\"");
        }
    }

    void expectCurlyRight(Token t) throws ScanException {
        this.expectNotNull(t, "}");
        if (t.type != Token.Type.CURLY_RIGHT) {
            throw new ScanException("Expecting }");
        }
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }
}

