/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.core.subst;

import com.newrelic.ch.qos.logback.core.spi.PropertyContainer;
import com.newrelic.ch.qos.logback.core.spi.ScanException;
import com.newrelic.ch.qos.logback.core.subst.Node;
import com.newrelic.ch.qos.logback.core.subst.Parser;
import com.newrelic.ch.qos.logback.core.subst.Tokenizer;
import com.newrelic.ch.qos.logback.core.util.OptionHelper;

public class NodeToStringTransformer {
    final Node node;
    final PropertyContainer propertyContainer0;
    final PropertyContainer propertyContainer1;

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer0, PropertyContainer propertyContainer1) {
        this.node = node;
        this.propertyContainer0 = propertyContainer0;
        this.propertyContainer1 = propertyContainer1;
    }

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer0) {
        this(node, propertyContainer0, null);
    }

    public static String substituteVariable(String input, PropertyContainer pc0, PropertyContainer pc1) throws ScanException {
        Tokenizer tokenizer = new Tokenizer(input);
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, pc0, pc1);
        return nodeToStringTransformer.transform();
    }

    public String transform() {
        StringBuilder stringBuilder = new StringBuilder();
        this.compileNode(this.node, stringBuilder);
        return stringBuilder.toString();
    }

    private void compileNode(Node inputNode, StringBuilder stringBuilder) {
        Node n = inputNode;
        while (n != null) {
            switch (n.type) {
                case LITERAL: {
                    this.handleLiteral(n, stringBuilder);
                    break;
                }
                case VARIABLE: {
                    this.handleVariable(n, stringBuilder);
                }
            }
            n = n.next;
        }
    }

    private void handleVariable(Node n, StringBuilder stringBuilder) {
        StringBuilder keyBuffer = new StringBuilder();
        Node payload = (Node)n.payload;
        this.compileNode(payload, keyBuffer);
        String key = keyBuffer.toString();
        String value = this.lookupKey(key);
        if (value != null) {
            stringBuilder.append(value);
            return;
        }
        if (n.defaultPart == null) {
            stringBuilder.append(key + "_IS_UNDEFINED");
            return;
        }
        Node defaultPart = (Node)n.defaultPart;
        StringBuilder defaultPartBuffer = new StringBuilder();
        this.compileNode(defaultPart, defaultPartBuffer);
        String defaultVal = defaultPartBuffer.toString();
        stringBuilder.append(defaultVal);
    }

    private String lookupKey(String key) {
        String value = this.propertyContainer0.getProperty(key);
        if (value != null) {
            return value;
        }
        if (this.propertyContainer1 != null && (value = this.propertyContainer1.getProperty(key)) != null) {
            return value;
        }
        value = OptionHelper.getSystemProperty(key, null);
        if (value != null) {
            return value;
        }
        value = OptionHelper.getEnv(key);
        if (value != null) {
            return value;
        }
        return null;
    }

    private void handleLiteral(Node n, StringBuilder stringBuilder) {
        stringBuilder.append((String)n.payload);
    }
}

