/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.core.status;

import com.newrelic.ch.qos.logback.core.spi.ContextAwareBase;
import com.newrelic.ch.qos.logback.core.spi.LifeCycle;
import com.newrelic.ch.qos.logback.core.status.Status;
import com.newrelic.ch.qos.logback.core.status.StatusListener;
import com.newrelic.ch.qos.logback.core.status.StatusManager;
import com.newrelic.ch.qos.logback.core.util.StatusPrinter;
import java.io.PrintStream;
import java.util.List;

abstract class OnPrintStreamStatusListenerBase
extends ContextAwareBase
implements StatusListener,
LifeCycle {
    boolean isStarted = false;
    static final long DEFAULT_RESTROSPECTIVE = 300L;
    long retrospective = 300L;

    OnPrintStreamStatusListenerBase() {
    }

    protected abstract PrintStream getPrintStream();

    private void print(Status status) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStr(sb, "", status);
        this.getPrintStream().print(sb);
    }

    public void addStatusEvent(Status status) {
        if (!this.isStarted) {
            return;
        }
        this.print(status);
    }

    private void retrospectivePrint() {
        if (this.context == null) {
            return;
        }
        long now = System.currentTimeMillis();
        StatusManager sm = this.context.getStatusManager();
        List<Status> statusList = sm.getCopyOfStatusList();
        for (Status status : statusList) {
            long timestamp = status.getDate();
            if (now - timestamp >= this.retrospective) continue;
            this.print(status);
        }
    }

    public void start() {
        this.isStarted = true;
        if (this.retrospective > 0L) {
            this.retrospectivePrint();
        }
    }

    public void setRetrospective(long retrospective) {
        this.retrospective = retrospective;
    }

    public long getRetrospective() {
        return this.retrospective;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }
}

