/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.core.rolling.helper;

import com.newrelic.ch.qos.logback.core.rolling.helper.DefaultArchiveRemover;
import com.newrelic.ch.qos.logback.core.rolling.helper.FileNamePattern;
import com.newrelic.ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.io.File;
import java.util.Date;

public class TimeBasedArchiveRemover
extends DefaultArchiveRemover {
    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        super(fileNamePattern, rc);
    }

    protected void cleanByPeriodOffset(Date now, int periodOffset) {
        Date date2delete = this.rc.getRelativeDate(now, periodOffset);
        String filename = this.fileNamePattern.convert(date2delete);
        File file2Delete = new File(filename);
        if (file2Delete.exists() && file2Delete.isFile()) {
            file2Delete.delete();
            this.addInfo("deleting " + file2Delete);
            if (this.parentClean) {
                this.removeFolderIfEmpty(file2Delete.getParentFile());
            }
        }
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }
}

