/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.core.joran.spi;

import com.newrelic.ch.qos.logback.core.joran.event.BodyEvent;
import com.newrelic.ch.qos.logback.core.joran.event.EndEvent;
import com.newrelic.ch.qos.logback.core.joran.event.SaxEvent;
import com.newrelic.ch.qos.logback.core.joran.event.StartEvent;
import com.newrelic.ch.qos.logback.core.joran.spi.Interpreter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPlayer {
    final Interpreter interpreter;
    List<SaxEvent> eventList;
    int currentIndex;

    public EventPlayer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List<SaxEvent> getCopyOfPlayerEventList() {
        return new ArrayList<SaxEvent>(this.eventList);
    }

    public void play(List<SaxEvent> aSaxEventList) {
        this.eventList = aSaxEventList;
        this.currentIndex = 0;
        while (this.currentIndex < this.eventList.size()) {
            SaxEvent se = this.eventList.get(this.currentIndex);
            if (se instanceof StartEvent) {
                this.interpreter.startElement((StartEvent)se);
                this.interpreter.getInterpretationContext().fireInPlay(se);
            }
            if (se instanceof BodyEvent) {
                this.interpreter.getInterpretationContext().fireInPlay(se);
                this.interpreter.characters((BodyEvent)se);
            }
            if (se instanceof EndEvent) {
                this.interpreter.getInterpretationContext().fireInPlay(se);
                this.interpreter.endElement((EndEvent)se);
            }
            ++this.currentIndex;
        }
    }

    public void addEventsDynamically(List<SaxEvent> eventList, int offset) {
        this.eventList.addAll(this.currentIndex + offset, eventList);
    }
}

