/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.core;

import com.newrelic.ch.qos.logback.core.OutputStreamAppender;
import com.newrelic.ch.qos.logback.core.recovery.ResilientFileOutputStream;
import com.newrelic.ch.qos.logback.core.spi.LogbackLock;
import com.newrelic.ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAppender<E>
extends OutputStreamAppender<E> {
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;

    public void setFile(String file) {
        this.fileName = file == null ? file : file.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int errors = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            try {
                this.openFile(this.getFile());
            }
            catch (IOException e) {
                ++errors;
                this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", e);
            }
        } else {
            ++errors;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (errors == 0) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String file_name) throws IOException {
        LogbackLock logbackLock = this.lock;
        synchronized (logbackLock) {
            boolean result;
            File file = new File(file_name);
            if (FileUtil.isParentDirectoryCreationRequired(file) && !(result = FileUtil.createMissingParentDirectories(file))) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFos = new ResilientFileOutputStream(file, this.append);
            resilientFos.setContext(this.context);
            this.setOutputStream(resilientFos);
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean prudent) {
        this.prudent = prudent;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(E event) throws IOException {
        ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFOS.getChannel();
        if (fileChannel == null) {
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long position = fileChannel.position();
            long size = fileChannel.size();
            if (size != position) {
                fileChannel.position(size);
            }
            super.writeOut(event);
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
        }
    }

    @Override
    protected void writeOut(E event) throws IOException {
        if (this.prudent) {
            this.safeWrite(event);
        } else {
            super.writeOut(event);
        }
    }
}

