/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.classic.turbo;

import com.newrelic.ch.qos.logback.classic.Level;
import com.newrelic.ch.qos.logback.classic.Logger;
import com.newrelic.ch.qos.logback.classic.turbo.LRUMessageCache;
import com.newrelic.ch.qos.logback.classic.turbo.TurboFilter;
import com.newrelic.ch.qos.logback.core.spi.FilterReply;
import com.newrelic.org.slf4j.Marker;

public class DuplicateMessageFilter
extends TurboFilter {
    public static final int DEFAULT_CACHE_SIZE = 100;
    public static final int DEFAULT_ALLOWED_REPETITIONS = 5;
    public int allowedRepetitions = 5;
    public int cacheSize = 100;
    private LRUMessageCache msgCache;

    public void start() {
        this.msgCache = new LRUMessageCache(this.cacheSize);
        super.start();
    }

    public void stop() {
        this.msgCache.clear();
        this.msgCache = null;
        super.stop();
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        int count = this.msgCache.getMessageCountAndThenIncrement(format);
        if (count <= this.allowedRepetitions) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public int getAllowedRepetitions() {
        return this.allowedRepetitions;
    }

    public void setAllowedRepetitions(int allowedRepetitions) {
        this.allowedRepetitions = allowedRepetitions;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

