/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.classic.sift;

import com.newrelic.ch.qos.logback.classic.spi.ILoggingEvent;
import com.newrelic.ch.qos.logback.core.sift.Discriminator;
import com.newrelic.ch.qos.logback.core.spi.ContextAwareBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextBasedDiscriminator
extends ContextAwareBase
implements Discriminator<ILoggingEvent> {
    private static final String KEY = "contextName";
    private String defaultValue;
    private boolean started = false;

    @Override
    public String getDiscriminatingValue(ILoggingEvent event) {
        String contextName = event.getLoggerContextVO().getName();
        if (contextName == null) {
            return this.defaultValue;
        }
        return contextName;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public void setKey(String key) {
        throw new UnsupportedOperationException("Key cannot be set. Using fixed key contextName");
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

