/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.ch.qos.logback.classic.pattern;

import com.newrelic.ch.qos.logback.classic.pattern.ClassicConverter;
import com.newrelic.ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDCConverter
extends ClassicConverter {
    String key;
    private static final String EMPTY_STRING = "";

    @Override
    public void start() {
        this.key = this.getFirstOption();
        super.start();
    }

    @Override
    public void stop() {
        this.key = null;
        super.stop();
    }

    @Override
    public String convert(ILoggingEvent event) {
        Map<String, String> mdcPropertyMap = event.getMDCPropertyMap();
        if (mdcPropertyMap == null) {
            return EMPTY_STRING;
        }
        if (this.key == null) {
            return this.outputMDCForAllKeys(mdcPropertyMap);
        }
        String value = event.getMDCPropertyMap().get(this.key);
        if (value != null) {
            return value;
        }
        return EMPTY_STRING;
    }

    private String outputMDCForAllKeys(Map<String, String> mdcPropertyMap) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : mdcPropertyMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return buf.toString();
    }
}

