/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class BootstrapAgent {
    private static final String NEW_RELIC_JAR_FILE = "newrelic.jar";
    private static final String AGENT_CLASS_NAME = "com.newrelic.agent.Agent";
    private static final String NEW_RELIC_BOOTSTRAP_CLASSPATH = "newrelic.bootstrap_classpath";

    private static JarFile getAgentJarFile(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return new JarFile(URLDecoder.decode(agentJarUrl.getFile(), "UTF-8"));
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getAgentJarUrl() {
        ClassLoader classLoader = BootstrapAgent.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                if (!url.getFile().endsWith(NEW_RELIC_JAR_FILE)) continue;
                return url;
            }
            String agentClassName = BootstrapAgent.class.getName().replace('.', '/') + ".class";
            for (URL url : urls) {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(url.getFile());
                    ZipEntry entry = jarFile.getEntry(agentClassName);
                    if (entry == null) continue;
                    URL uRL = url;
                    return uRL;
                }
                catch (IOException e) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return null;
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        if (Boolean.getBoolean(NEW_RELIC_BOOTSTRAP_CLASSPATH)) {
            BootstrapAgent.appendJarToBootstrapClassLoader(inst);
        }
        try {
            Class<?> agentClass = ClassLoader.getSystemClassLoader().loadClass(AGENT_CLASS_NAME);
            Method premain = agentClass.getDeclaredMethod("premain", String.class, Instrumentation.class);
            premain.invoke(null, agentArgs, inst);
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t));
            t.printStackTrace();
        }
    }

    private static void appendJarToBootstrapClassLoader(Instrumentation inst) {
        URL agentJarUrl = BootstrapAgent.getAgentJarUrl();
        JarFile agentJarFile = BootstrapAgent.getAgentJarFile(agentJarUrl);
        if (agentJarFile != null) {
            inst.appendToBootstrapClassLoaderSearch(agentJarFile);
        }
    }
}

