/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.WebRequestDispatcher;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.transaction.SameOrHigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import com.newrelic.api.agent.IncrementCounter;
import com.newrelic.api.agent.RecordMetric;
import com.newrelic.api.agent.RecordResponseTimeMetric;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewRelicApiImplementation {
    public static void recordMetric(String name, float value) {
        if (name == null || name.length() == 0) {
            Agent.LOG.finer("recordMetric was invoked with a null or empty name");
            return;
        }
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null || tx.getLastTracer() == null) {
                ServiceFactory.getStatsService().doStatsWork(new RecordMetric(name, value));
            } else {
                tx.getTransactionStats().getUnscopedStats().getStats(name).recordDataPoint(value);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Recorded metric \"{0}\": {1}", name, Float.valueOf(value));
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception recording metric \"{0}\": {1}", name, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public static void recordResponseTimeMetric(String name, long millis) {
        if (name == null || name.length() == 0) {
            Agent.LOG.finer("recordResponseTimeMetric was invoked with a null or empty name");
            return;
        }
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null || tx.getLastTracer() == null) {
                ServiceFactory.getStatsService().doStatsWork(new RecordResponseTimeMetric(millis, name));
            } else {
                tx.getTransactionStats().getUnscopedStats().getResponseTimeStats(name).recordResponseTime(millis, TimeUnit.MILLISECONDS);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Recorded response time metric \"{0}\": {1}", name, millis);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception recording response time metric \"{0}\": {1}", name, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public static void incrementCounter(String name) {
        NewRelicApiImplementation.incrementCounter(name, 1, false);
    }

    public static void incrementCounter(String name, int count) {
        NewRelicApiImplementation.incrementCounter(name, count, false);
    }

    public static void incrementCounter(String name, int count, boolean monotonicallyIncreasing) {
        if (name == null || name.length() == 0) {
            Agent.LOG.finer("incrementCounter was invoked with a null metric name");
            return;
        }
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null || tx.getLastTracer() == null) {
                ServiceFactory.getStatsService().doStatsWork(new IncrementCounter(name, count));
            } else {
                tx.getTransactionStats().getUnscopedStats().getStats(name).incrementCallCount(count);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("incremented counter \"{0}\": {1}", name, count);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception incrementing counter \"{0}\": {1}", name, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public static void noticeError(Throwable throwable, Map<String, String> params) {
        try {
            ErrorService.reportException(throwable, params == null ? new TreeMap<String, String>() : new TreeMap<String, String>(params));
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", throwable);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", throwable, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public static void noticeError(Throwable throwable) {
        Map<String, String> params = Collections.emptyMap();
        NewRelicApiImplementation.noticeError(throwable, params);
    }

    public static void noticeError(String message, Map<String, String> params) {
        try {
            ErrorService.reportError(message, params == null ? new TreeMap<String, String>() : new TreeMap<String, String>(params));
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", message);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", message, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public static void noticeError(String message) {
        Map<String, String> params = Collections.emptyMap();
        NewRelicApiImplementation.noticeError(message, params);
    }

    public static void addCustomParameter(String key, Number value) {
        NewRelicApiImplementation.addCustomParameterImpl(key, value);
    }

    public static void addCustomParameter(String key, String value) {
        NewRelicApiImplementation.addCustomParameterImpl(key, value);
    }

    private static void addCustomParameterImpl(String key, Object value) {
        if (key == null) {
            Agent.LOG.finer("addCustomParameter was invoked with a null key");
        } else if (value == null) {
            String msg = MessageFormat.format("addCustomParameter was invoked with a null value for key \"{0}\"", key);
            Agent.LOG.finer(msg);
        } else {
            try {
                Transaction.getTransaction().getParameters().put(key, value);
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Added customer parameter \"{0}\": {1}", key, value);
                    Agent.LOG.finer(msg);
                }
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("Exception adding custom parameter for key: \"{0}\": {1}", key, t);
                NewRelicApiImplementation.logException(msg, t);
            }
        }
    }

    public static void setTransactionName(String category, String name) {
        Transaction transaction;
        Dispatcher dispatcher;
        if (category == null) {
            category = "Custom";
        }
        if (name == null || name.length() == 0) {
            Agent.LOG.log(Level.FINER, "Unable to set the transaction name to an empty string");
            return;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((dispatcher = (transaction = Transaction.getTransaction()).getDispatcher()) == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the transaction name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        boolean isWebTransaction = dispatcher.isWebTransaction();
        String normalizedTransactionName = MessageFormat.format("{0}/{1}{2}", isWebTransaction ? "WebTransaction" : "OtherTransaction", category, name);
        SameOrHigherPriorityTransactionNamingPolicy policy = SameOrHigherPriorityTransactionNamingPolicy.getInstance();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(transaction, TransactionNamePriority.REQUEST_ATTRIBUTE)) {
            String msg = MessageFormat.format("Setting {1} transaction name to \"{0}\" in NewRelic API", name, isWebTransaction ? "web" : "background");
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(transaction, normalizedTransactionName, null, TransactionNamePriority.REQUEST_ATTRIBUTE);
    }

    public static void ignoreTransaction() {
        Transaction transaction = Transaction.getTransaction();
        if (transaction.getLastTracer() == null) {
            Agent.LOG.fine("ignoreTransaction invoked with no transaction");
        } else {
            transaction.setIgnore(true);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer("Set ignore transaction in NewRelic API");
            }
        }
    }

    public static void ignoreApdex() {
        Dispatcher dispatcher;
        Transaction transaction = Transaction.getTransaction();
        Dispatcher dispatcher2 = dispatcher = transaction == null ? null : transaction.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer("ignoreApdex invoked with no transaction");
        } else if (dispatcher instanceof WebRequestDispatcher) {
            ((WebRequestDispatcher)dispatcher).setIgnoreApdex(true);
            Agent.LOG.finer("Set ignoreApdex in NewRelic API");
        } else {
            Agent.LOG.finer("ignoreApdex invoked with no web transaction");
        }
    }

    public static void setRequestAndResponse(Request request, Response response) {
        Transaction transaction = Transaction.getTransaction();
        WebRequestDispatcher dispatcher = new WebRequestDispatcher(new RequestDelegate(request), new ResponseDelegate(response), transaction);
        transaction.setDispatcher(dispatcher);
        Agent.LOG.finest("Custom request dispatcher registered");
    }

    public static String getBrowserTimingHeaderForContentType(String contentType) {
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null) {
                Agent.LOG.finer("Unable to inject browser timing header in a JSP: not running in a transaction");
                return "";
            }
            String header = tx.getBeaconTransactionState().getBrowserTimingHeaderForJsp();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing header in a JSP: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error injecting browser timing header in a JSP: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    public static String getBrowserTimingHeader() {
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null) {
                Agent.LOG.finer("Unable to get browser timing header in NewRelic API: not running in a transaction");
                return "";
            }
            String header = tx.getBeaconTransactionState().getBrowserTimingHeader();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing header in NewRelic API: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting browser timing header in NewRelic API: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    public static String getBrowserTimingFooterForContentType(String contentType) {
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null) {
                Agent.LOG.finer("Unable to inject browser timing footer in a JSP: not running in a transaction");
                return "";
            }
            String footer = tx.getBeaconTransactionState().getBrowserTimingFooter();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing footer in a JSP: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error injecting browser timing footer in a JSP: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    public static String getBrowserTimingFooter() {
        try {
            Transaction tx = Transaction.getTransaction();
            if (tx == null) {
                Agent.LOG.finer("Unable to get browser timing footer in NewRelic API: not running in a transaction");
                return "";
            }
            String footer = tx.getBeaconTransactionState().getBrowserTimingFooter();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing footer in NewRelic API: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting browser timing footer in NewRelic API: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    public static void setUserName(String name) {
        Transaction tx = Transaction.getTransaction();
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        tx.getBeaconTransactionState().setUserName(name);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Set user name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
    }

    public static void setAccountName(String name) {
        Transaction tx = Transaction.getTransaction();
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        tx.getBeaconTransactionState().setAccountName(name);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Set account name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
    }

    public static void setProductName(String name) {
        Transaction tx = Transaction.getTransaction();
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        tx.getBeaconTransactionState().setProductName(name);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Set product name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
    }

    private static void logException(String msg, Throwable t) {
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.FINEST, msg, t);
        } else if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestDelegate
    implements HttpRequest {
        private final Request request;

        public RequestDelegate(Request request) {
            this.request = request;
        }

        @Override
        public String getRequestURI() {
            return this.request.getRequestURI();
        }

        @Override
        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        @Override
        public String getRemoteUser() {
            return this.request.getRemoteUser();
        }

        @Override
        public Enumeration<?> getParameterNames() {
            return this.request.getParameterNames();
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.request.getParameterValues(name);
        }

        @Override
        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        @Override
        public String getCookieValue(String name) {
            return null;
        }

        @Override
        public boolean isAsyncStarted() {
            return false;
        }

        @Override
        public boolean isAsyncSupported() {
            return false;
        }

        @Override
        public AsyncContextNr getAsyncContextNr() {
            return null;
        }
    }

    private static class ResponseDelegate
    implements HttpResponse {
        private final Response response;

        public ResponseDelegate(Response response) {
            this.response = response;
        }

        public int _nr_getResponseStatus() throws Exception {
            return this.response.getStatus();
        }

        public String _nr_getResponseStatusMessage() throws Exception {
            return this.response.getStatusMessage();
        }

        public void _nr_setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public String _nr_getContentType() {
            return null;
        }
    }
}

