/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    private static final String NEWRELIC_INTERNAL_PACKAGE_NAME = "com/newrelic/";
    private static final String NEWRELIC_PACKAGE_NAME = "com.newrelic.";

    private Strings() {
    }

    public static boolean isBlank(String str) {
        return str == null || str.length() == 0;
    }

    public static Collection<String> trim(Collection<String> strings) {
        ArrayList<String> trimmedList = new ArrayList<String>(strings.size());
        for (String string : strings) {
            trimmedList.add(string.trim());
        }
        return trimmedList;
    }

    public static String unquoteDatabaseName(String s) {
        int index = s.indexOf(46);
        if (index > 0) {
            return new StringBuilder(s.length()).append(Strings.unquote(s.substring(0, index))).append('.').append(Strings.unquote(s.substring(index + 1))).toString();
        }
        return Strings.unquote(s);
    }

    public static String join(char delimiter, String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = strings.length - 1;
        for (String s : strings) {
            length += s.length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append(delimiter).append(strings[i]);
        }
        return sb.toString();
    }

    public static String[] split(String string, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        ArrayList<String> segments = new ArrayList<String>(4);
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        return segments.toArray(new String[segments.size()]);
    }

    public static String unquote(String string) {
        char last;
        if (string == null || string.length() < 2) {
            return string;
        }
        char first = string.charAt(0);
        if (first != (last = string.charAt(string.length() - 1)) || first != '\"' && first != '\'' && first != '`') {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String fixClassName(String className) {
        return Strings.trimName(className, NEWRELIC_PACKAGE_NAME, "org.");
    }

    private static String trimName(String fullName, String name, String prefix) {
        if (fullName.startsWith(name + prefix)) {
            return fullName.substring(name.length());
        }
        return fullName;
    }

    public static String fixInternalClassName(String className) {
        className = className.replace('.', '/');
        return Strings.trimName(className, NEWRELIC_INTERNAL_PACKAGE_NAME, "org/");
    }
}

