/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.instrumentation.ClassAnnotationVisitor;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.util.Streams;
import com.newrelic.org.objectweb.asm.ClassReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotations {
    private Annotations() {
    }

    public static <T extends Class> Collection<Class> getAnnotationClasses(T annotationClass, String packageSearchPath) {
        String pointcutAnnotation = 'L' + annotationClass.getName().replace('.', '/') + ';';
        if (!packageSearchPath.endsWith("/")) {
            packageSearchPath = packageSearchPath + "/";
        }
        Pattern pattern = Pattern.compile(packageSearchPath + "(.*).class");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Collection<String> fileNames = AgentJarHelper.findAgentJarFileNames(pattern);
        ArrayList<Class> classes = new ArrayList<Class>(fileNames.size());
        for (String fileName : fileNames) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Streams.copy(ClassTransformer.class.getResourceAsStream('/' + fileName), (OutputStream)out, true);
                ClassReader cr = new ClassReader(out.toByteArray());
                Collection<String> annotations = ClassAnnotationVisitor.getAnnotations(cr);
                if (!annotations.contains(pointcutAnnotation)) continue;
                String className = fileName.replace('/', '.');
                int index = className.indexOf(".class");
                if (index > 0) {
                    className = className.substring(0, index);
                }
                Class<?> clazz = classLoader.loadClass(className);
                classes.add(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classes;
    }
}

