/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.transaction.TransactionNamePriority;
import java.text.MessageFormat;

public class PriorityTransactionName {
    public static final PriorityTransactionName NONE = PriorityTransactionName.create(null, null, TransactionNamePriority.NONE);
    private final TransactionNamePriority priority;
    private final String name;
    private final String prefix;
    private final String partialName;

    private PriorityTransactionName(String prefix, String partialName, TransactionNamePriority priority) {
        this.prefix = prefix;
        this.partialName = partialName;
        this.name = this.initializeName(prefix, partialName);
        this.priority = priority;
    }

    private String initializeName(String prefix, String partialName) {
        if (prefix == null) {
            return null;
        }
        if (partialName == null) {
            return prefix;
        }
        return prefix + partialName;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPartialName() {
        return this.partialName;
    }

    public boolean isFrozen() {
        return this.priority == TransactionNamePriority.FROZEN;
    }

    public PriorityTransactionName freeze() {
        if (this.isFrozen()) {
            return this;
        }
        return PriorityTransactionName.create(this.getPrefix(), this.getPartialName(), TransactionNamePriority.FROZEN);
    }

    public TransactionNamePriority getPriority() {
        return this.priority;
    }

    public String toString() {
        return MessageFormat.format("{0}[name={1}, priority={2}]", new Object[]{this.getClass().getName(), this.getName(), this.getPriority()});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        PriorityTransactionName other = (PriorityTransactionName)o;
        if (this.name == null) {
            return other.name == null && this.priority.equals((Object)other.priority);
        }
        return this.name.equals(other.name) && this.priority.equals((Object)other.priority);
    }

    public int hashCode() {
        int result = 1;
        if (this.name != null) {
            result = result * 17 + this.name.hashCode();
        }
        result = result * 31 + this.priority.hashCode();
        return result;
    }

    public static PriorityTransactionName create(String transactionName, TransactionNamePriority priority) {
        if (transactionName == null) {
            return new PriorityTransactionName(null, null, priority);
        }
        int index = transactionName.indexOf(47, 1);
        if (index > 0 && (index = transactionName.indexOf(47, index + 1)) > 0) {
            String prefix = transactionName.substring(0, index);
            String partialName = transactionName.substring(index);
            return new PriorityTransactionName(prefix, partialName, priority);
        }
        return new PriorityTransactionName(transactionName, null, priority);
    }

    public static PriorityTransactionName create(String prefix, String partialName, TransactionNamePriority priority) {
        if (priority == null) {
            return null;
        }
        return new PriorityTransactionName(prefix, partialName, priority);
    }
}

