/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionNamePriority;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.util.Strings;

public abstract class AbstractTransactionNamingPolicy
implements TransactionNamingPolicy {
    public final void setTransactionName(Transaction tx, String name, String category, TransactionNamePriority priority) {
        if (this.canSetTransactionName(tx, priority)) {
            tx.setPriorityTransactionName(this.getPriorityTransactionName(tx, name, category, priority));
        }
    }

    public abstract boolean canSetTransactionName(Transaction var1, TransactionNamePriority var2);

    private PriorityTransactionName getPriorityTransactionName(Transaction tx, String name, String category, TransactionNamePriority priority) {
        String txType;
        if (category == null) {
            return PriorityTransactionName.create(name, priority);
        }
        if (name == null) {
            return PriorityTransactionName.create(name, priority);
        }
        String string = txType = tx.isWebTransaction() ? "WebTransaction" : "OtherTransaction";
        if (!Strings.isEmpty(name)) {
            if (name.startsWith(txType)) {
                return PriorityTransactionName.create(name, priority);
            }
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
        }
        return PriorityTransactionName.create(txType + '/' + category, name, priority);
    }

    public void setPriority(Transaction tx, TransactionNamePriority priority) {
        PriorityTransactionName ptn = PriorityTransactionName.create(tx.getPriorityTransactionName().getName(), priority);
        tx.setPriorityTransactionName(ptn);
    }
}

