/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import com.newrelic.agent.transaction.TransactionNamer;

public abstract class AbstractTransactionNamer
implements TransactionNamer {
    private final Transaction tx;
    private final String uri;

    protected AbstractTransactionNamer(Transaction tx, String uri) {
        this.tx = tx;
        this.uri = uri;
    }

    protected final String getUri() {
        return this.uri;
    }

    protected final Transaction getTransaction() {
        return this.tx;
    }

    protected boolean canSetTransactionName() {
        if (this.tx == null || this.tx.isIgnore()) {
            return false;
        }
        HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
        return policy.canSetTransactionName(this.tx, TransactionNamePriority.REQUEST_URI);
    }

    protected void setTransactionName(String name, String category, TransactionNamePriority priority) {
        if (this.canSetTransactionName()) {
            HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
            policy.setTransactionName(this.tx, name, category, priority);
        }
    }
}

