/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.instrumentation.AgentWrapper;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.RetryException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;

public class ServletAsyncTransactionStateImpl
extends TransactionStateImpl {
    private static final ClassMethodSignature ASYNC_PROCESSING_SIG = new ClassMethodSignature("NR_RECORD_ASYNC_PROCESSING_CLASS", "NR_RECORD_ASYNC_PROCESSING_METHOD", "()V");
    private static final MetricNameFormat ASYNC_PROCESSING_FORMAT = new SimpleMetricNameFormat("AsyncProcessing");
    private static final TracerFactory ASYNC_TRACER_FACTORY = new AsyncTracerFactory();
    private static final Object[] ASYNC_TRACER_ARGS = new Object[]{176, null};
    private final AsyncContextNr asyncContext;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private volatile AbstractTracer rootTracer;
    private volatile AbstractTracer asyncProcessingTracer;

    public ServletAsyncTransactionStateImpl(AsyncContextNr asyncContext) {
        this.asyncContext = asyncContext;
    }

    public Tracer getTracer(Transaction tx, TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
        AbstractTracer tracer;
        if (this.state.compareAndSet(State.RESUMING, State.RUNNING) && (tracer = this.resumeRootTracer()) != null) {
            return tracer;
        }
        return super.getTracer(tx, tracerFactory, signature, object, args);
    }

    public void resume() {
        if (!this.state.compareAndSet(State.SUSPENDING, State.RESUMING)) {
            return;
        }
        Transaction savedTx = this.getAndClearSavedTransaction();
        if (savedTx == null) {
            return;
        }
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.finest(MessageFormat.format("Resuming transaction {0}", savedTx));
        }
        Transaction.clearTransaction();
        Transaction.setTransaction(savedTx);
        throw new RetryException();
    }

    public void suspendRootTracer() {
        if (!this.state.compareAndSet(State.RUNNING, State.SUSPENDING)) {
            return;
        }
        Transaction currentTx = Transaction.getTransaction();
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.finest(MessageFormat.format("Transaction {0} is suspended", currentTx));
        }
    }

    public void complete() {
        if (!this.state.compareAndSet(State.SUSPENDING, State.RUNNING)) {
            return;
        }
        Transaction savedTx = this.getAndClearSavedTransaction();
        if (savedTx == null) {
            return;
        }
        Transaction currentTx = Transaction.getTransaction();
        Transaction.clearTransaction();
        Transaction.setTransaction(savedTx);
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.finest(MessageFormat.format("Completing transaction {0}", savedTx));
        }
        AbstractTracer tracer = this.resumeRootTracer();
        tracer.invoke(AgentWrapper.SUCCESSFUL_METHOD_INVOCATION, null, ASYNC_TRACER_ARGS);
        Transaction.clearTransaction();
        if (currentTx.getLastTracer() == null) {
            return;
        }
        Transaction.setTransaction(currentTx);
    }

    public boolean finish(Transaction tx, Tracer tracer) {
        if (this.state.get() == State.SUSPENDING && tracer == tx.getRootTracer()) {
            this.suspendRootTracer(tx, tracer);
            return false;
        }
        return true;
    }

    private void suspendRootTracer(Transaction tx, Tracer tracer) {
        this.rootTracer = (AbstractTracer)tracer;
        this.startAsyncProcessingTracer(tx);
        this.saveTransaction(tx);
        Transaction.clearTransaction();
    }

    private void startAsyncProcessingTracer(Transaction tx) {
        if (this.asyncProcessingTracer == null) {
            this.asyncProcessingTracer = (AbstractTracer)super.getTracer(tx, ASYNC_TRACER_FACTORY, ASYNC_PROCESSING_SIG, null, null);
        }
    }

    private AbstractTracer resumeRootTracer() {
        this.stopAsyncProcessingTracer();
        AbstractTracer tracer = this.rootTracer;
        this.rootTracer = null;
        return tracer;
    }

    private void stopAsyncProcessingTracer() {
        if (this.asyncProcessingTracer != null) {
            this.asyncProcessingTracer.invoke(AgentWrapper.SUCCESSFUL_METHOD_INVOCATION, null, ASYNC_TRACER_ARGS);
        }
        this.asyncProcessingTracer = null;
    }

    private void saveTransaction(Transaction tx) {
        this.asyncContext._nr_setTransaction(tx);
    }

    private Transaction getAndClearSavedTransaction() {
        if (this.asyncContext == null) {
            return null;
        }
        Transaction tx = (Transaction)this.asyncContext._nr_getTransaction();
        if (tx == null) {
            return null;
        }
        this.asyncContext._nr_setTransaction(null);
        return tx;
    }

    private static class AsyncTracerFactory
    implements TracerFactory {
        private AsyncTracerFactory() {
        }

        public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
            return new DefaultTracer(tx, sig, object, ASYNC_PROCESSING_FORMAT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RESUMING,
        RUNNING,
        SUSPENDING;

    }
}

