/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.servlet.ExternalTimeTracker;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueueTimeTracker {
    protected static final String REQUEST_X_QUEUE_START_HEADER = "X-Queue-Start";
    protected static final String REQUEST_X_QUEUE_TIME_HEADER = "X-Queue-Time";
    private static final Pattern REQUEST_X_QUEUE_HEADER_PATTERN = Pattern.compile("\\s*t=([0-9]+)", 32);
    private final long queueTime;

    private QueueTimeTracker(HttpRequest httpRequest, long txStartTimeInMillis) {
        String requestXQueueStartHeader = ExternalTimeTracker.getRequestHeader(httpRequest, REQUEST_X_QUEUE_START_HEADER);
        String requestXQueueTimeHeader = ExternalTimeTracker.getRequestHeader(httpRequest, REQUEST_X_QUEUE_TIME_HEADER);
        this.queueTime = this.initQueueTime(requestXQueueTimeHeader, requestXQueueStartHeader, txStartTimeInMillis);
    }

    private long initQueueTime(String requestXQueueTimeHeader, String requestXQueueStartHeader, long txStartTimeInMillis) {
        long queueTime = this.initQueueTimeHeader(requestXQueueTimeHeader);
        if (queueTime > 0L) {
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Queue time (microseconds): {0}", String.valueOf(queueTime));
                Agent.LOG.finest(msg);
            }
            return queueTime;
        }
        long queueStartTime = this.getQueueStartTimeFromHeader(requestXQueueStartHeader);
        if (queueStartTime > 0L) {
            long txStartTime = TimeUnit.MICROSECONDS.convert(txStartTimeInMillis, TimeUnit.MILLISECONDS);
            queueTime = txStartTime - queueStartTime;
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Transaction start time (microseconds): {0}, queue start time (microseconds): {1}, queue time (microseconds): {2}", String.valueOf(txStartTime), String.valueOf(queueStartTime), String.valueOf(queueTime));
                Agent.LOG.finest(msg);
            }
            return Math.max(0L, queueTime);
        }
        return 0L;
    }

    private long initQueueTimeHeader(String requestXQueueTimeHeader) {
        if (requestXQueueTimeHeader != null) {
            Matcher matcher = REQUEST_X_QUEUE_HEADER_PATTERN.matcher(requestXQueueTimeHeader);
            if (matcher.find()) {
                String queueTime = matcher.group(1);
                try {
                    return Long.parseLong(queueTime);
                }
                catch (NumberFormatException e) {
                    String msg = MessageFormat.format("Error parsing queue time {0} in {1} header: {2}", queueTime, REQUEST_X_QUEUE_TIME_HEADER, e);
                    Agent.LOG.log(Level.FINER, msg);
                }
            } else {
                String msg = MessageFormat.format("Failed to parse queue time in {0} header: {1}", REQUEST_X_QUEUE_TIME_HEADER, requestXQueueTimeHeader);
                Agent.LOG.log(Level.WARNING, msg);
            }
        }
        return 0L;
    }

    private long getQueueStartTimeFromHeader(String requestXQueueStartHeader) {
        if (requestXQueueStartHeader != null) {
            Matcher matcher = REQUEST_X_QUEUE_HEADER_PATTERN.matcher(requestXQueueStartHeader);
            if (matcher.find()) {
                String queueStartTime = matcher.group(1);
                try {
                    return Long.parseLong(queueStartTime);
                }
                catch (NumberFormatException e) {
                    String msg = MessageFormat.format("Error parsing queue start time {0} in {1} header: {2}", queueStartTime, REQUEST_X_QUEUE_START_HEADER, e);
                    Agent.LOG.log(Level.FINER, msg);
                }
            } else {
                String msg = MessageFormat.format("Failed to parse queue start time in {0} header: {1}", REQUEST_X_QUEUE_TIME_HEADER, requestXQueueStartHeader);
                Agent.LOG.log(Level.WARNING, msg);
            }
        }
        return 0L;
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public void recordMetrics(TransactionStats statsEngine) {
        if (this.queueTime > 0L) {
            MetricName name = MetricName.QUEUE_TIME;
            statsEngine.getUnscopedStats().getResponseTimeStats(name.getName()).recordResponseTime(this.queueTime, TimeUnit.MICROSECONDS);
        }
    }

    public static QueueTimeTracker create(HttpRequest httpRequest, long txStartTimeInMillis) {
        return new QueueTimeTracker(httpRequest, txStartTimeInMillis);
    }
}

