/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.SkipTracerException;
import com.newrelic.agent.tracers.WebRequestDispatcher;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.util.logging.Level;

public class BasicRequestDispatcherTracer
extends DefaultTracer
implements DispatcherTracer {
    private WebRequestDispatcher webDispatcher;

    public BasicRequestDispatcherTracer(Transaction transaction, ClassMethodSignature sig, Object dispatcher, HttpRequest request, HttpResponse response) {
        this(transaction, sig, dispatcher, request, response, new SimpleMetricNameFormat("RequestDispatcher", ClassMethodMetricNameFormat.getMetricName(sig, dispatcher, "RequestDispatcher")));
    }

    public BasicRequestDispatcherTracer(Transaction transaction, ClassMethodSignature sig, Object dispatcher, HttpRequest request, HttpResponse response, MetricNameFormat metricNameFormatter) {
        super(transaction, sig, dispatcher, metricNameFormatter);
        this.webDispatcher = new WebRequestDispatcher(request, response, transaction);
        transaction.setDispatcher(this.webDispatcher);
        DispatcherTracer rootTracer = transaction.getRootTracer();
        if (rootTracer != null) {
            throw new SkipTracerException();
        }
    }

    public final HttpResponse getResponse() {
        return this.webDispatcher.getResponse();
    }

    public final String getUri() {
        return this.webDispatcher.getUri();
    }

    public final String getCookieValue(String name) {
        return this.webDispatcher.getCookieValue(name);
    }

    public final String getHeader(String name) {
        return this.webDispatcher.getHeader(name);
    }

    public final HttpRequest getRequest() {
        return this.webDispatcher.getRequest();
    }

    public void setRequest(HttpRequest request) {
        this.webDispatcher.setRequest(request);
    }

    public void setResponse(HttpResponse response) {
        this.webDispatcher.setResponse(response);
    }

    public void setTransactionName() {
        this.webDispatcher.setTransactionName();
    }

    public boolean isIgnoreApdex() {
        return this.webDispatcher.isIgnoreApdex();
    }

    protected void reset() {
        super.reset();
        this.webDispatcher = null;
    }

    protected final void doFinish(Throwable throwable) {
        try {
            this.noticeFinish(this.webDispatcher.getRequest(), throwable);
            this.transaction.setThrowable(throwable);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "An error occurred calling noticeFinish() for dispatcher tracer with an exception", e);
        }
    }

    protected void noticeFinish(Object request, Throwable throwable) throws Exception {
    }

    public ITransactionTracerConfig getTransactionTracerConfig() {
        return this.transaction.getAgentConfig().getRequestTransactionTracerConfig();
    }

    public boolean isWebTransaction() {
        return true;
    }

    public void transactionFinished(String transactionName) {
    }
}

