/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.text.MessageFormat;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicRequestDispatcherPointCut
extends TracerFactoryPointCut {
    public BasicRequestDispatcherPointCut(Class<? extends TracerFactoryPointCut> tracerFactory, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(tracerFactory, classMatcher, methodMatcher);
    }

    public BasicRequestDispatcherPointCut(PointCutConfiguration config, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(config, classMatcher, methodMatcher);
    }

    @Override
    public final Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        DispatcherTracer rootTracer = transaction.getRootTracer();
        if (rootTracer != null) {
            return null;
        }
        try {
            return new BasicRequestDispatcherTracer(transaction, sig, object, this.getRequest(transaction, sig, object, args), this.getResponse(transaction, sig, object, args), this.getMetricNameFormat(transaction, sig, object, args));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to create request dispatcher tracer: {0}", e.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.SEVERE, msg, e);
            return null;
        }
    }

    protected MetricNameFormat getMetricNameFormat(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        return new SimpleMetricNameFormat("RequestDispatcher", ClassMethodMetricNameFormat.getMetricName(sig, object, "RequestDispatcher"));
    }

    protected abstract HttpResponse getResponse(Transaction var1, ClassMethodSignature var2, Object var3, Object[] var4) throws Exception;

    protected abstract HttpRequest getRequest(Transaction var1, ClassMethodSignature var2, Object var3, Object[] var4) throws Exception;
}

