/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.servlet.AbstractAsyncContextTracer;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.util.CleverClassLoader;
import java.lang.reflect.Method;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncContextTracer
extends AbstractAsyncContextTracer {
    private static final String ADD_LISTENER_METHOD_NAME = "addListener";
    private static final String ASYNC_LISTENER_CLASS = "javax.servlet.AsyncListener";
    private static final String ASYNC_LISTENER_IMPL_CLASS = "com.newrelic.agent.tracers.servlet.AsyncListenerImpl";
    private static volatile Object ASYNC_LISTENER;
    private static volatile Method ADD_LISTENER_METHOD;
    private static volatile boolean IS_INITIALIZED;

    public AsyncContextTracer(Transaction tx, ClassMethodSignature sig, Object object, MetricNameFormat format) {
        super(tx, sig, object, format);
    }

    @Override
    protected void doFinish(int opcode, Object returnValue) {
        AsyncContextNr asyncContext = null;
        if (returnValue instanceof AsyncContextNr) {
            asyncContext = (AsyncContextNr)returnValue;
        }
        if (returnValue != null && asyncContext == null) {
            String msg = MessageFormat.format("Async context {0} is not an instance of {1}", returnValue.getClass().getName(), AsyncContextNr.class.getName());
            Agent.LOG.finest(msg);
            return;
        }
        this.addListener(asyncContext);
        this.suspendTransaction(asyncContext);
    }

    private void addListener(AsyncContextNr asyncContext) {
        if (asyncContext._nr_getListener()) {
            return;
        }
        asyncContext._nr_setListener(true);
        if (!IS_INITIALIZED) {
            AsyncContextTracer.initAsyncListener(asyncContext);
        }
        if (ADD_LISTENER_METHOD == null || ASYNC_LISTENER == null) {
            return;
        }
        try {
            ADD_LISTENER_METHOD.invoke((Object)asyncContext, ASYNC_LISTENER);
            if (Agent.LOG.isFinestEnabled()) {
                String msg = MessageFormat.format("Added listener to async context: {0}", asyncContext.getClass().getName());
                Agent.LOG.finest(msg);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception invoking addListener method on async context {0}: {1}", asyncContext.getClass().getName(), e);
            Agent.LOG.finest(msg);
        }
    }

    private static synchronized void initAsyncListener(Object asyncContext) {
        if (IS_INITIALIZED) {
            return;
        }
        IS_INITIALIZED = true;
        try {
            Class<?> asyncContextClass = asyncContext.getClass();
            ClassLoader asyncContextClassLoader = asyncContextClass.getClassLoader();
            ASYNC_LISTENER = AsyncContextTracer.getAsyncListener(asyncContextClassLoader);
            Class<?> asyncListenerClass = asyncContextClassLoader.loadClass(ASYNC_LISTENER_CLASS);
            ADD_LISTENER_METHOD = AsyncContextTracer.getAddListenerMethod(asyncContextClass, asyncListenerClass);
            ADD_LISTENER_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            ADD_LISTENER_METHOD = null;
            String msg = MessageFormat.format("Exception initializing async context listener: {0}", e);
            Agent.LOG.warning(msg);
        }
    }

    private static Method getAddListenerMethod(Class<?> asyncContextClass, Class<?> asyncListenerClass) {
        try {
            return asyncContextClass.getMethod(ADD_LISTENER_METHOD_NAME, asyncListenerClass);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception getting addListener method for {0}: {1}", asyncContextClass.getName(), e);
            Agent.LOG.finest(msg);
            return null;
        }
    }

    private static Object getAsyncListener(ClassLoader asyncContextClassLoader) throws Exception {
        CleverClassLoader classLoader = new CleverClassLoader(asyncContextClassLoader);
        Class listenerClazz = classLoader.loadClassSpecial(ASYNC_LISTENER_IMPL_CLASS);
        return listenerClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

