/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.AgentWrapper;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

public abstract class AbstractTracer
implements Tracer,
ExitTracer {
    protected final Transaction transaction;

    public AbstractTracer(Transaction transaction) {
        this.transaction = transaction;
    }

    public final Transaction getTransaction() {
        return this.transaction;
    }

    public final Object invoke(Object methodName, Method method, Object[] args) {
        try {
            if (!this.transaction.getTransactionState().finish(this.transaction, this)) {
                return null;
            }
            if (args == null) {
                Agent.LOG.severe("Tracer.finish() was invoked with no arguments");
            } else if (AgentWrapper.SUCCESSFUL_METHOD_INVOCATION == methodName) {
                if (args.length == 2) {
                    this.finish((Integer)args[0], args[1]);
                } else {
                    Agent.LOG.severe(MessageFormat.format("Tracer.finish(int, Object) was invoked with {0} arguments(s)", args.length));
                }
            } else if (AgentWrapper.UNSUCCESSFUL_METHOD_INVOCATION == methodName) {
                if (args.length == 1) {
                    this.finish((Throwable)args[0]);
                } else {
                    Agent.LOG.severe(MessageFormat.format("Tracer.finish(Throwable) was invoked with {0} arguments(s)", args.length));
                }
            } else {
                Agent.LOG.severe(MessageFormat.format("Tracer.finish was invoked with an unknown method: {0}", methodName));
            }
        }
        catch (Throwable t) {
            Agent.LOG.severe(MessageFormat.format("An error occurred finishing method tracer {0} : {1}", this.getClass().getName(), t.toString()));
            Agent.LOG.fine(MessageFormat.format("An error occurred finishing method tracer for signature : {0}", this.getClassMethodSignature()));
            Agent.LOG.log(Level.FINER, t.getMessage(), t);
        }
        return null;
    }

    public abstract ClassMethodSignature getClassMethodSignature();
}

