/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.AbstractExternalComponentTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.CrossProcessNameFormat;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCrossProcessTracer
extends AbstractExternalComponentTracer {
    private CrossProcessNameFormat crossProcessFormat;
    private final String uri;

    public AbstractCrossProcessTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String uri, String methodName) {
        super(transaction, sig, object, host, library, uri, methodName);
        this.uri = uri;
    }

    protected void doFinish(int opcode, Object returnValue) {
        super.doFinish(opcode, returnValue);
        String encodedAppData = this.getHeaderValue(returnValue, "X-NewRelic-App-Data");
        String encodingKey = this.transaction.getCrossProcessConfig().getEncodingKey();
        this.crossProcessFormat = CrossProcessNameFormat.create(this.getHost(), this.uri, encodedAppData, encodingKey);
        if (this.crossProcessFormat != null) {
            String transactionId = this.crossProcessFormat.getTransactionId();
            if (transactionId != null && transactionId.length() > 0) {
                this.put("transaction_guid", transactionId);
            }
            this.setMetricNameFormat(this.crossProcessFormat);
            if (Agent.LOG.isFinestEnabled()) {
                String msg = MessageFormat.format("Received {0} cross process response header for external call: {1}", "X-NewRelic-App-Data", this.crossProcessFormat.toString());
                Agent.LOG.finest(msg);
            }
        }
    }

    protected abstract String getHeaderValue(Object var1, String var2);

    protected void doRecordMetrics(TransactionStats transactionStats) {
        super.doRecordMetrics(transactionStats);
        if (this.crossProcessFormat != null) {
            String hostCrossProcessIdRollupMetricName = this.crossProcessFormat.getHostCrossProcessIdRollupMetricName();
            transactionStats.getUnscopedStats().getResponseTimeStats(hostCrossProcessIdRollupMetricName).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        }
    }
}

