/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.AbstractCommand;
import com.newrelic.agent.commands.CommandException;
import com.newrelic.agent.trace.NamedTransactionSampler;
import com.newrelic.agent.trace.TransactionTraceService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTraceCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "transaction_trace";
    private static final String DISABLED_MESSAGE = "Transaction traces are disabled";
    private final TransactionTraceService transactionTraceService;

    public TransactionTraceCommand(TransactionTraceService transactionTraceService) {
        super(COMMAND_NAME);
        this.transactionTraceService = transactionTraceService;
    }

    @Override
    public Map<?, ?> process(IRPMService rpmService, Map arguments) throws CommandException {
        if (this.transactionTraceService.isEnabled()) {
            return this.processEnabled(rpmService, arguments);
        }
        return this.processDisabled(rpmService, arguments);
    }

    public Map<?, ?> processEnabled(IRPMService rpmService, Map<?, ?> arguments) throws CommandException {
        if (arguments.size() < 3) {
            throw new CommandException("The transaction_trace command expected 3 arguments");
        }
        Object duration = arguments.remove("duration");
        Object max_traces = arguments.remove("max_traces");
        Object named_transaction = arguments.remove("named_transaction");
        if (!(duration instanceof Number)) {
            String msg = MessageFormat.format("The {0} command received an invalid duration: {1}", COMMAND_NAME, duration);
            throw new CommandException(msg);
        }
        if (!(max_traces instanceof Number)) {
            String msg = MessageFormat.format("The {0} command received an invalid period: {1}", COMMAND_NAME, max_traces);
            throw new CommandException(msg);
        }
        if (!(named_transaction instanceof String)) {
            String msg = MessageFormat.format("The {0} command received an invalid named transaction: {1}", COMMAND_NAME, named_transaction);
            throw new CommandException(msg);
        }
        int maxTraces = ((Number)max_traces).intValue();
        Double durationInSeconds = ((Number)duration).doubleValue();
        String namedTransaction = (String)named_transaction;
        ArrayList<String> namedTransactions = new ArrayList<String>(1);
        namedTransactions.add(namedTransaction);
        NamedTransactionSampler.startSampler(rpmService.getApplicationName(), namedTransactions, maxTraces, durationInSeconds);
        return Collections.EMPTY_MAP;
    }

    public Map<?, ?> processDisabled(IRPMService rpmService, Map<?, ?> arguments) throws CommandException {
        Agent.LOG.log(Level.INFO, DISABLED_MESSAGE);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error", DISABLED_MESSAGE);
        return map;
    }
}

