/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.metric.MetricIdRegistry;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.SimpleStatsEngine;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsEngineImpl
implements StatsEngine {
    private static final float HASH_SET_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_CAPACITY = 140;
    public static final int DEFAULT_SCOPED_CAPACITY = 32;
    public static final int DOUBLE = 2;
    private final SimpleStatsEngine unscopedStats;
    private final Map<String, SimpleStatsEngine> scopedStats;

    public StatsEngineImpl() {
        this(140);
    }

    public StatsEngineImpl(int capacity) {
        this.unscopedStats = new SimpleStatsEngine(capacity);
        this.scopedStats = new HashMap<String, SimpleStatsEngine>(capacity);
    }

    @Override
    public Stats getStats(String name) {
        return this.getStats(MetricName.create(name));
    }

    @Override
    public Stats getStats(MetricName metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        return this.getStatsEngine(metricName).getStats(metricName.getName());
    }

    private SimpleStatsEngine getStatsEngine(MetricName metricName) {
        if (metricName.isScoped()) {
            SimpleStatsEngine statsEngine = this.scopedStats.get(metricName.getScope());
            if (statsEngine == null) {
                statsEngine = new SimpleStatsEngine(32);
                this.scopedStats.put(metricName.getScope(), statsEngine);
            }
            return statsEngine;
        }
        return this.unscopedStats;
    }

    @Override
    public ResponseTimeStats getResponseTimeStats(String name) {
        return this.getResponseTimeStats(MetricName.create(name));
    }

    @Override
    public ResponseTimeStats getResponseTimeStats(MetricName metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        return this.getStatsEngine(metricName).getResponseTimeStats(metricName.getName());
    }

    @Override
    public ApdexStats getApdexStats(MetricName metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        return this.getStatsEngine(metricName).getApdexStats(metricName.getName());
    }

    @Override
    public List<MetricName> getMetricNames() {
        ArrayList<MetricName> result = new ArrayList<MetricName>(this.getSize());
        for (String string : this.unscopedStats.getStatsMap().keySet()) {
            result.add(MetricName.create(string));
        }
        for (Map.Entry entry : this.scopedStats.entrySet()) {
            for (String name : ((SimpleStatsEngine)entry.getValue()).getStatsMap().keySet()) {
                result.add(MetricName.create(name, (String)entry.getKey()));
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.unscopedStats.clear();
        this.scopedStats.clear();
    }

    @Override
    public int getSize() {
        int size = this.unscopedStats.getStatsMap().size();
        for (SimpleStatsEngine engine : this.scopedStats.values()) {
            size += engine.getStatsMap().size();
        }
        return size;
    }

    @Override
    public void mergeStats(StatsEngine statsEngine) {
        if (statsEngine instanceof StatsEngineImpl) {
            this.mergeStats((StatsEngineImpl)statsEngine);
        }
    }

    private void mergeStats(StatsEngineImpl other) {
        this.unscopedStats.mergeStats(other.unscopedStats);
        for (Map.Entry<String, SimpleStatsEngine> entry : other.scopedStats.entrySet()) {
            SimpleStatsEngine scopedStatsEngine = this.scopedStats.get(entry.getKey());
            if (scopedStatsEngine == null) {
                scopedStatsEngine = new SimpleStatsEngine(entry.getValue().getSize());
                this.scopedStats.put(entry.getKey(), scopedStatsEngine);
            }
            scopedStatsEngine.mergeStats(entry.getValue());
        }
    }

    @Override
    public void mergeStatsResolvingScope(TransactionStats txStats, String resolvedScope) {
        this.unscopedStats.mergeStats(txStats.getUnscopedStats());
        if (resolvedScope == null) {
            return;
        }
        SimpleStatsEngine scopedStatsEngine = this.scopedStats.get(resolvedScope);
        if (scopedStatsEngine == null) {
            scopedStatsEngine = new SimpleStatsEngine(txStats.getScopedStats().getSize());
            this.scopedStats.put(resolvedScope, scopedStatsEngine);
        }
        scopedStatsEngine.mergeStats(txStats.getScopedStats());
    }

    @Override
    public List<MetricData> getMetricData(Normalizer metricNormalizer, MetricIdRegistry metricIdRegistry) {
        ArrayList<MetricData> result = new ArrayList<MetricData>(this.unscopedStats.getStatsMap().size() + this.scopedStats.size() * 32 * 2);
        for (Map.Entry<String, SimpleStatsEngine> entry : this.scopedStats.entrySet()) {
            result.addAll(entry.getValue().getMetricData(metricNormalizer, metricIdRegistry, entry.getKey()));
        }
        result.addAll(this.createUnscopedCopies(metricNormalizer, metricIdRegistry, result));
        result.addAll(this.unscopedStats.getMetricData(metricNormalizer, metricIdRegistry, ""));
        return StatsEngineImpl.aggregate(metricIdRegistry, result);
    }

    private List<MetricData> createUnscopedCopies(Normalizer metricNormalizer, MetricIdRegistry metricIdRegistry, List<MetricData> scopedMetrics) {
        int size = (int)((double)scopedMetrics.size() / 0.75) + 2;
        HashMap<String, MetricData> allUnscopedMetrics = new HashMap<String, MetricData>(size);
        ArrayList<MetricData> results = new ArrayList<MetricData>(scopedMetrics.size());
        for (MetricData scoped : scopedMetrics) {
            String theMetricName = scoped.getMetricName().getName();
            MetricData unscopedMetric = this.getUnscopedCloneOfData(metricNormalizer, metricIdRegistry, theMetricName, scoped.getStats());
            if (unscopedMetric == null) continue;
            MetricData mapUnscoped = (MetricData)allUnscopedMetrics.get(theMetricName);
            if (mapUnscoped == null) {
                allUnscopedMetrics.put(theMetricName, unscopedMetric);
                results.add(unscopedMetric);
                continue;
            }
            mapUnscoped.getStats().merge(unscopedMetric.getStats());
        }
        return results;
    }

    private MetricData getUnscopedCloneOfData(Normalizer metricNormalizer, MetricIdRegistry metricIdRegistry, String metricName, StatsBase stats) {
        if (stats != null) {
            MetricName metricNameUnscoped = MetricName.create(metricName);
            try {
                MetricData metricDataUnscoped = SimpleStatsEngine.createMetricData(metricNameUnscoped, (StatsBase)stats.clone(), metricNormalizer, metricIdRegistry);
                return metricDataUnscoped;
            }
            catch (CloneNotSupportedException e) {
                Agent.LOG.log(Level.INFO, "Unscoped metric not created because stats base could not be cloned for " + metricNameUnscoped.getName());
                return null;
            }
        }
        return null;
    }

    static List<MetricData> aggregate(MetricIdRegistry metricIdRegistry, List<MetricData> result) {
        if (metricIdRegistry.getSize() == 0) {
            return result;
        }
        int hashMapSize = (int)((float)result.size() / 0.75f) + 1;
        HashMap<Object, MetricData> data = new HashMap<Object, MetricData>(hashMapSize);
        for (MetricData md : result) {
            MetricData existing = (MetricData)data.get(md.getKey());
            if (existing == null) {
                data.put(md.getKey(), md);
                continue;
            }
            existing.getStats().merge(md.getStats());
        }
        if (data.size() == result.size()) {
            return result;
        }
        return new ArrayList<MetricData>(data.values());
    }
}

