/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class ApdexStatsImpl
implements ApdexStats {
    private static final Integer ZERO = 0;
    private int satisfying;
    private int tolerating;
    private int frustrating;
    private long apdexTInMillis = ZERO.intValue();

    ApdexStatsImpl() {
    }

    public ApdexStatsImpl(int s, int t, int f) {
        this.satisfying = s;
        this.tolerating = t;
        this.frustrating = f;
    }

    public Object clone() throws CloneNotSupportedException {
        ApdexStatsImpl newStats = new ApdexStatsImpl();
        newStats.frustrating = this.frustrating;
        newStats.satisfying = this.satisfying;
        newStats.tolerating = this.tolerating;
        return newStats;
    }

    public void recordApdexFrustrated() {
        ++this.frustrating;
    }

    public int getApdexSatisfying() {
        return this.satisfying;
    }

    public int getApdexTolerating() {
        return this.tolerating;
    }

    public int getApdexFrustrating() {
        return this.frustrating;
    }

    public void recordApdexResponseTime(long responseTimeMillis, long apdexTInMillis) {
        this.apdexTInMillis = apdexTInMillis;
        if (responseTimeMillis <= apdexTInMillis) {
            ++this.satisfying;
        } else if (responseTimeMillis <= 4L * apdexTInMillis) {
            ++this.tolerating;
        } else {
            this.recordApdexFrustrated();
        }
    }

    public boolean hasData() {
        return this.satisfying > 0 || this.tolerating > 0 || this.frustrating > 0;
    }

    public void reset() {
        this.satisfying = 0;
        this.tolerating = 0;
        this.frustrating = 0;
    }

    public void writeJSONString(Writer writer) throws IOException {
        double apdexT = Long.valueOf(this.apdexTInMillis).doubleValue() / 1000.0;
        List<Number> data = Arrays.asList(this.satisfying, this.tolerating, this.frustrating, apdexT, apdexT, ZERO);
        JSONArray.writeJSONString(data, writer);
    }

    public void merge(StatsBase statsObj) {
        if (statsObj instanceof ApdexStatsImpl) {
            ApdexStatsImpl stats = (ApdexStatsImpl)statsObj;
            this.satisfying += stats.satisfying;
            this.tolerating += stats.tolerating;
            this.frustrating += stats.frustrating;
        }
    }
}

