/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.sql.SqlTracerAggregator;
import com.newrelic.agent.sql.SqlTracerListener;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTracerAggregatorImpl
implements SqlTracerAggregator {
    public static final String BACKTRACE_KEY = "backtrace";
    public static final String EXPLAIN_PLAN_KEY = "explain_plan";
    public static final int SQL_LIMIT_PER_REPORTING_PERIOD = 10;
    private static final Pattern IN_CLAUSE_PATTERN = Pattern.compile("\\([?,\\s]*\\)");
    private static final String IN_CLAUSE_REPLACEMENT = "(?)";
    private final ConcurrentMap<String, SqlStatementInfo> sqlStatements = new ConcurrentHashMap<String, SqlStatementInfo>();
    private final Lock readLock;
    private final Lock writeLock;

    public SqlTracerAggregatorImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlTrace> getAndClearSqlTracers() {
        List<SqlStatementInfo> infos = null;
        this.writeLock.lock();
        try {
            infos = this.getAndClearSqlTracersUnderLock();
        }
        finally {
            this.writeLock.unlock();
        }
        if (infos == null || infos.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createSqlTraces(infos);
    }

    private List<SqlTrace> createSqlTraces(List<SqlStatementInfo> infos) {
        List<SqlStatementInfo> topInfos = this.getTopTracers(infos);
        ArrayList<SqlTrace> result = new ArrayList<SqlTrace>(topInfos.size());
        for (SqlStatementInfo topInfo : topInfos) {
            result.add(topInfo.asSqlTrace());
        }
        return result;
    }

    private List<SqlStatementInfo> getTopTracers(List<SqlStatementInfo> infos) {
        if (infos.size() <= 10) {
            return infos;
        }
        Collections.sort(infos);
        return infos.subList(0, 10);
    }

    private List<SqlStatementInfo> getAndClearSqlTracersUnderLock() {
        ArrayList<SqlStatementInfo> result = new ArrayList<SqlStatementInfo>(this.sqlStatements.values());
        this.sqlStatements.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSqlTracers(TransactionData td) {
        SqlTracerListener listener = td.getSqlTracerListener();
        if (listener == null) {
            return;
        }
        List<SqlStatementTracer> sqlTracers = listener.getSqlTracers();
        if (sqlTracers.isEmpty()) {
            return;
        }
        this.readLock.lock();
        try {
            this.addSqlTracersUnderLock(td, sqlTracers);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addSqlTracersUnderLock(TransactionData td, List<SqlStatementTracer> sqlTracers) {
        for (SqlStatementTracer sqlTracer : sqlTracers) {
            this.addSqlTracer(td, sqlTracer);
        }
    }

    public String obfuscateSql(String sql) {
        SqlObfuscator sqlObfuscator = ServiceFactory.getDatabaseService().getDefaultSqlObfuscator();
        return this.obfuscateInClauses(sqlObfuscator.obfuscateSql(sql));
    }

    private String obfuscateInClauses(String sql) {
        return IN_CLAUSE_PATTERN.matcher(sql).replaceAll(IN_CLAUSE_REPLACEMENT);
    }

    private void addSqlTracer(TransactionData td, SqlStatementTracer sqlTracer) {
        String sql;
        Object sqlObj = sqlTracer.getSql();
        String string = sql = sqlObj == null ? null : sqlObj.toString();
        if (sql == null || sql.length() == 0) {
            return;
        }
        String obfuscatedSql = this.obfuscateSql(sql);
        if (obfuscatedSql == null) {
            return;
        }
        SqlStatementInfo info = this.getSqlStatementInfo(td, sqlTracer, obfuscatedSql);
        info.aggregate(td, sqlTracer);
    }

    private SqlStatementInfo getSqlStatementInfo(TransactionData td, SqlStatementTracer sqlTracer, String obfuscatedSql) {
        SqlStatementInfo info = (SqlStatementInfo)this.sqlStatements.get(obfuscatedSql);
        if (info != null) {
            return info;
        }
        int id = obfuscatedSql.hashCode();
        info = new SqlStatementInfo(td, sqlTracer, id);
        SqlStatementInfo oldInfo = this.sqlStatements.putIfAbsent(obfuscatedSql, info);
        return oldInfo == null ? info : oldInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SqlTraceImpl
    implements SqlTrace,
    JSONStreamAware {
        private final String blameMetricName;
        private final String metricName;
        private final String uri;
        private final String sql;
        private final int id;
        private final int callCount;
        private final long total;
        private final long max;
        private final long min;
        private final Map<String, Object> parameters;

        public SqlTraceImpl(SqlStatementInfo info) {
            this.blameMetricName = info.getBlameMetricName();
            this.metricName = info.getMetricName();
            this.uri = info.getRequestUri();
            this.sql = info.getSql();
            this.id = info.getId();
            this.callCount = info.getCallCount();
            this.total = info.getTotalInMillis();
            this.min = info.getMinInMillis();
            this.max = info.getMaxInMillis();
            this.parameters = info.getParameters();
        }

        @Override
        public String getBlameMetricName() {
            return this.blameMetricName;
        }

        @Override
        public String getMetricName() {
            return this.metricName;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public int getCallCount() {
            return this.callCount;
        }

        @Override
        public long getMax() {
            return this.max;
        }

        @Override
        public long getMin() {
            return this.min;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public long getTotal() {
            return this.total;
        }

        @Override
        public void writeJSONString(Writer out) throws IOException {
            JSONArray.writeJSONString(Arrays.asList(this.blameMetricName, this.uri, this.id, this.sql, this.metricName, this.callCount, this.total, this.min, this.max, DataSenderWriter.getJsonifiedCompressedEncodedString(this.parameters, out)), out);
        }
    }

    private static class SqlTracerInfo {
        private final TransactionData transactionData;
        private final SqlStatementTracer sqlTracer;

        private SqlTracerInfo(TransactionData transactionData, SqlStatementTracer sqlTracer) {
            this.transactionData = transactionData;
            this.sqlTracer = sqlTracer;
        }

        public TransactionData getTransactionData() {
            return this.transactionData;
        }

        public SqlStatementTracer getSqlTracer() {
            return this.sqlTracer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SqlStatementInfo
    implements Comparable<SqlStatementInfo> {
        private final AtomicReference<SqlTracerInfo> slowestSql = new AtomicReference();
        private final int id;
        private final AtomicInteger callCount = new AtomicInteger();
        private final AtomicLong total = new AtomicLong();
        private final AtomicLong max = new AtomicLong();
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);

        private SqlStatementInfo(TransactionData td, SqlStatementTracer sqlTracer, int id) {
            this.slowestSql.set(new SqlTracerInfo(td, sqlTracer));
            this.id = id;
        }

        public TransactionData getTransactionData() {
            return this.slowestSql.get().getTransactionData();
        }

        public SqlStatementTracer getSqlStatementTracer() {
            return this.slowestSql.get().getSqlTracer();
        }

        @Override
        public int compareTo(SqlStatementInfo other) {
            Long thisMax = this.max.get();
            Long otherMax = other.max.get();
            return otherMax.compareTo(thisMax);
        }

        public void aggregate(TransactionData td, SqlStatementTracer sqlTracer) {
            this.callCount.incrementAndGet();
            long duration = sqlTracer.getDuration();
            this.total.addAndGet(duration);
            this.replaceMin(duration);
            this.replaceMax(duration);
            this.replaceSqlTracer(td, sqlTracer);
        }

        public SqlTrace asSqlTrace() {
            SqlStatementTracer sqlTracer = this.getSqlStatementTracer();
            DatabaseService dbService = ServiceFactory.getDatabaseService();
            dbService.runExplainPlan(sqlTracer);
            return new SqlTraceImpl(this);
        }

        public String getBlameMetricName() {
            return this.getTransactionData().getBlameMetricName();
        }

        public String getMetricName() {
            return this.getSqlStatementTracer().getMetricName();
        }

        public int getId() {
            return this.id;
        }

        public String getSql() {
            SqlStatementTracer sqlTracer = this.getSqlStatementTracer();
            String sql = sqlTracer.getSql().toString();
            String appName = this.getTransactionData().getApplicationName();
            SqlObfuscator sqlObfuscator = ServiceFactory.getDatabaseService().getSqlObfuscator(appName);
            String obfuscatedSql = sqlObfuscator.obfuscateSql(sql);
            int maxSqlLength = sqlTracer.getTransaction().getTransactionTracerConfig().getInsertSqlMaxLength();
            return TransactionSegment.truncateSql(obfuscatedSql, maxSqlLength);
        }

        public String getRequestUri() {
            return this.getTransactionData().getRequestUri();
        }

        public int getCallCount() {
            return this.callCount.get();
        }

        public long getTotalInMillis() {
            return TimeUnit.MILLISECONDS.convert(this.total.get(), TimeUnit.NANOSECONDS);
        }

        public long getMinInMillis() {
            return TimeUnit.MILLISECONDS.convert(this.min.get(), TimeUnit.NANOSECONDS);
        }

        public long getMaxInMillis() {
            return TimeUnit.MILLISECONDS.convert(this.max.get(), TimeUnit.NANOSECONDS);
        }

        public Map<String, Object> getParameters() {
            SqlStatementTracer sqlTracer = this.getSqlStatementTracer();
            return this.createParameters(sqlTracer);
        }

        private Map<String, Object> createParameters(SqlStatementTracer sqlTracer) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Object explainPlan = sqlTracer.getParameters().get("explanation");
            parameters.put(SqlTracerAggregatorImpl.EXPLAIN_PLAN_KEY, explainPlan);
            List<StackTraceElement> backtrace = (List<StackTraceElement>)sqlTracer.getParameters().get(SqlTracerAggregatorImpl.BACKTRACE_KEY);
            if (backtrace != null) {
                backtrace = StackTraces.scrubAndTruncate(backtrace);
                List<String> backtraceStrings = StackTraces.toStringList(backtrace);
                parameters.put(SqlTracerAggregatorImpl.BACKTRACE_KEY, backtraceStrings);
            }
            return parameters;
        }

        private void replaceMin(long duration) {
            long currentDuration;
            do {
                if (duration < (currentDuration = this.min.get())) continue;
                return;
            } while (!this.min.compareAndSet(currentDuration, duration));
        }

        private void replaceMax(long duration) {
            long currentDuration;
            do {
                if (duration > (currentDuration = this.max.get())) continue;
                return;
            } while (!this.max.compareAndSet(currentDuration, duration));
        }

        private void replaceSqlTracer(TransactionData td, SqlStatementTracer sqlTracer) {
            SqlTracerInfo update;
            SqlTracerInfo current;
            do {
                current = this.slowestSql.get();
                if (sqlTracer.getDuration() > current.getSqlTracer().getDuration()) continue;
                return;
            } while (!this.slowestSql.compareAndSet(current, update = new SqlTracerInfo(td, sqlTracer)));
        }
    }
}

