/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.extension.ExtensionFileFilter;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.module.Jar;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleServiceProcessor {
    private static final String JAR_EXTENSION = ".jar";
    private static final String UNKNOWN_VERSION = " ";
    private static final int MAX_MAP_SIZE = 1000;
    private static final FileFilter JAR_FILTER = new ExtensionFileFilter(".jar");
    private final Map<String, List<String>> envJarsWithVersion = new HashMap<String, List<String>>();
    private final List<String> ignoreJars;

    public ModuleServiceProcessor() {
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.ignoreJars = config.getIgnoreJars();
    }

    protected synchronized List<Jar> processModuleData(List<URL[]> pUrlsToProcess, List<String[]> filePathsToProcess, boolean returnAllJars) {
        ArrayList<Jar> jars = new ArrayList<Jar>();
        if (returnAllJars) {
            this.addAllJars(jars);
        }
        if (this.envJarsWithVersion.size() < 1000) {
            for (URL[] urls : pUrlsToProcess) {
                this.processUrls(urls, jars);
            }
            for (String[] strings : filePathsToProcess) {
                this.processStrings(strings, jars);
            }
        }
        return jars;
    }

    private void addAllJars(List<Jar> jars) {
        Set<Map.Entry<String, List<String>>> it = this.envJarsWithVersion.entrySet();
        for (Map.Entry<String, List<String>> next : it) {
            for (String version : next.getValue()) {
                jars.add(new Jar(next.getKey(), version));
            }
        }
    }

    private void processStrings(String[] pStrings, List<Jar> jars) {
        if (pStrings != null) {
            for (String address : pStrings) {
                this.processFilePath(address, jars);
            }
        }
    }

    private void processUrls(URL[] pUrls, List<Jar> jars) {
        if (pUrls != null) {
            for (URL address : pUrls) {
                this.processUrl(address, jars);
            }
        }
    }

    private void processUrl(URL address, List<Jar> jars) {
        if (address != null) {
            String file = address.getFile();
            this.processFilePath(file, jars);
        }
    }

    private void processFilePath(String address, List<Jar> jars) {
        try {
            if (address != null) {
                Agent.LOG.log(Level.FINEST, MessageFormat.format("Processing file path {0}.", address));
                if (!this.checkAndHandleJar(address, jars) && !this.checkAndHandleDirectory(address, jars)) {
                    StringBuilder toLog = new StringBuilder();
                    toLog.append("{0} file does not have a supported ");
                    toLog.append("extension and so is being ignored");
                    toLog.append(" in environment variables.");
                    Agent.LOG.log(Level.FINEST, MessageFormat.format(toLog.toString(), address));
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Error processing the file path.", e);
        }
    }

    private boolean checkAndHandleJar(String filePath, List<Jar> jars) {
        boolean wasJar = false;
        try {
            if (filePath.endsWith(JAR_EXTENSION)) {
                this.handleJar(filePath, jars);
                wasJar = true;
            } else {
                int jarIndex = filePath.indexOf(JAR_EXTENSION);
                if (jarIndex > 0) {
                    int colonIndex = filePath.indexOf(":");
                    String name = colonIndex > 0 ? filePath.substring(colonIndex + 1, jarIndex + JAR_EXTENSION.length()) : filePath.substring(0, jarIndex + JAR_EXTENSION.length());
                    this.handleJar(name, jars);
                    wasJar = true;
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Problem trying to extract jar from path {0}.", filePath));
        }
        return wasJar;
    }

    private boolean checkAndHandleDirectory(String directory, List<Jar> jars) {
        boolean wasDir = false;
        try {
            File dir;
            if (directory.endsWith(File.separator) && (dir = new File(directory)).isDirectory()) {
                wasDir = true;
                File[] jarFiles = dir.listFiles(JAR_FILTER);
                if (jarFiles != null) {
                    for (File jFile : jarFiles) {
                        this.handleJar(jFile.getAbsolutePath(), jars);
                    }
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Trouble grabbing jars from the directory {0}. Stopping directory reading.", directory), e);
        }
        return wasDir;
    }

    private void handleJar(String file, List<Jar> jars) {
        try {
            Attributes attributes;
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (version == null && (version = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null) {
                    version = UNKNOWN_VERSION;
                }
                this.addJarAndVersion(file, version, jars);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Trouble getting version from {0} jar. Adding jar without version.", file), e);
            this.addJarAndVersion(file, UNKNOWN_VERSION, jars);
        }
    }

    private void addJarAndVersion(String jarFile, String version, List<Jar> jars) {
        if (jarFile != null) {
            if (version == null) {
                version = UNKNOWN_VERSION;
            }
            jarFile = this.parseJarName(jarFile);
            boolean added = false;
            if (this.shouldAttemptAdd(jarFile)) {
                added = this.performAdding(jarFile, version, jars);
            }
            if (added) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Adding the jar {0} with version {1}.", jarFile, version));
            } else {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Not taking the version {0} for jar {1}.", version, jarFile));
            }
        }
    }

    private String parseJarName(String jarName) {
        String jar = null;
        if (jarName != null) {
            int index = jarName.lastIndexOf("/");
            jar = index > 0 && index < jarName.length() ? jarName.substring(index + 1).trim() : jarName.trim();
        }
        return jar;
    }

    private boolean shouldAttemptAdd(String jarFile) {
        return !this.ignoreJars.contains(jarFile) && this.envJarsWithVersion.size() < 1000;
    }

    private boolean performAdding(String jarFile, String version, List<Jar> jars) {
        boolean added = false;
        List<String> versionFromOldMap = this.envJarsWithVersion.get(jarFile);
        if (versionFromOldMap == null) {
            versionFromOldMap = new ArrayList<String>();
            this.envJarsWithVersion.put(jarFile, versionFromOldMap);
        }
        if (!versionFromOldMap.contains(version)) {
            versionFromOldMap.add(version);
            jars.add(new Jar(jarFile, version));
            added = true;
        }
        return added;
    }
}

