/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.module.Jar;
import com.newrelic.agent.service.module.ModuleService;
import com.newrelic.agent.service.module.ModuleServiceProcessor;
import com.newrelic.agent.stats.StatsEngine;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ModuleServiceImpl
extends AbstractService
implements ModuleService,
HarvestListener {
    private static final int MAX_DRAIN_PER_ITERATION = 50;
    private final BlockingQueue<URL[]> urlsToProcess = new LinkedBlockingQueue<URL[]>();
    private final BlockingQueue<String[]> filePathsToProcess = new LinkedBlockingQueue<String[]>();
    private final List<Jar> modulesToSend = new ArrayList<Jar>();
    private final ModuleServiceProcessor processor = new ModuleServiceProcessor();
    private long lastAllJarFlush = 0L;
    private final String defaultApp;

    public ModuleServiceImpl() {
        super(ModuleService.class.getSimpleName());
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.defaultApp = config.getApplicationName();
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    private boolean needToSendAllJars() {
        return ServiceFactory.getRPMService().getConnectionTimestamp() > this.lastAllJarFlush;
    }

    public synchronized void beforeHarvest(String pAppName, StatsEngine pStatsEngine) {
        if (!this.defaultApp.equals(pAppName)) {
            return;
        }
        Agent.LOG.log(Level.FINER, "Harvesting Modules");
        boolean sendAll = this.needToSendAllJars();
        ArrayList<URL[]> urls = new ArrayList<URL[]>(50);
        this.urlsToProcess.drainTo(urls, 50);
        ArrayList<String[]> strings = new ArrayList<String[]>(50);
        this.filePathsToProcess.drainTo(strings, 50);
        List<Jar> jars = this.processor.processModuleData(urls, strings, sendAll);
        if (sendAll) {
            this.lastAllJarFlush = System.nanoTime();
            this.modulesToSend.clear();
        } else if (!this.modulesToSend.isEmpty()) {
            jars.addAll(this.modulesToSend);
            this.modulesToSend.clear();
        }
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            for (Jar jar : jars) {
                sb.append("   ");
                sb.append(jar.getName());
                sb.append(":");
                sb.append(jar.getVersion());
            }
            Agent.LOG.log(Level.FINEST, "Sending jars: " + sb.toString());
        }
        try {
            ServiceFactory.getRPMService(pAppName).sendModules(jars);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, MessageFormat.format("Unable to send {0} jars. Will attempt next harvest.", jars.size()));
            this.modulesToSend.addAll(jars);
        }
    }

    public void afterHarvest(String pAppName) {
    }

    public void addUrls(URL[] pUrlsToAdd) {
        if (pUrlsToAdd != null) {
            try {
                if (!this.urlsToProcess.offer(pUrlsToAdd, 0L, TimeUnit.NANOSECONDS)) {
                    Agent.LOG.log(Level.INFO, "Jars could not be added because queue is full.");
                }
            }
            catch (InterruptedException e) {
                Agent.LOG.log(Level.FINEST, "Thread interrupted when putting jars on queue.");
            }
        }
    }

    public void addFilePaths(String[] pFilePaths) {
        if (pFilePaths != null) {
            try {
                if (!this.filePathsToProcess.offer(pFilePaths, 0L, TimeUnit.NANOSECONDS)) {
                    Agent.LOG.log(Level.INFO, "Jars could not be added because queue is full.");
                }
            }
            catch (InterruptedException e) {
                Agent.LOG.log(Level.FINEST, "Thread interrupted when putting jars on queue.");
            }
        }
    }
}

