/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ThreadSampler
implements MetricSampler {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public void sample(StatsEngine statsEngine) {
        long[] deadlockedThreadIds;
        int threadCount = this.threadMXBean.getThreadCount();
        statsEngine.getStats("Threads/all").setCallCount(threadCount);
        try {
            deadlockedThreadIds = this.threadMXBean.findMonitorDeadlockedThreads();
        }
        catch (AccessControlException e) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("An error occurred calling ThreadMXBean.findMonitorDeadlockedThreads: {0}", e);
                Agent.LOG.warning(msg);
            }
            deadlockedThreadIds = new long[]{};
        }
        int deadlockCount = deadlockedThreadIds == null ? 0 : deadlockedThreadIds.length;
        statsEngine.getStats("Threads/Deadlocks/all").setCallCount(deadlockCount);
    }
}

